// Use the Enrollee Numbers from the CMS NHE
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: September 3, 2013


*********************************************************************
*************************** DATA NOTES ******************************
*********************************************************************

/*
Health Insurance Enrollment and Uninsured; Number of Enrollees and Annual Percent Change, Calendar Years 1987-2011	
SOURCE:	CMS NHE Tables, p. 27
URL: 	http://www.cms.gov/Research-Statistics-Data-and-Systems/Statistics-Trends-and-Reports/NationalHealthExpendData/Downloads/tables.pdf

Notes:  Due to overlaps of coverage the data are not additive.
 data not applicable (Data not available prior to 1987.)

 Other PHI includes insurance plans purchased on the private market that are not associated with an individuals employer or Medigap plan.

 Other public includes health insurance coverage provided by the Department of Veterans Affairs and the Department of Defense.
Source:  Centers for Medicare & Medicaid Services, Office of the Actuary, National Health Statistics Group.
*/

*********************************************************************
**************************** LOAD DATA ******************************
*********************************************************************

version 11.2
clear all
insheet using "../../1raw/NHE2011-num-enrollees.csv"


drop in 1/4
drop in 29/36
ren v1 year
ren v2 numenrollees_pvttot
ren v3 numenrollees_pvtind
ren v4 numenrollees_pvtothind
ren v5 numenrollees_pvtmedigap
ren v6 numenrollees_pvtemp
ren v7 numenrollees_medicare
ren v8 numenrollees_medicaid
ren v9 numenrollees_CHIP
ren v10 numenrollees_othpub
ren v11 numenrollees_uninsured
drop in 1/3

destring, replace ignore("")

foreach var of varlist  numenrollees_pvttot- numenrollees_uninsured {
	char define `var'[source] 	"CMS NHE"
	char define `var'[url] 		"http://www.cms.gov/Research-Statistics-Data-and-Systems/Statistics-Trends-and-Reports/NationalHealthExpendData/Downloads/tables.pdf"
}

label var numenrollees_pvttot 			"Number of Enrollees in Private Insurance (Millions)"
label var numenrollees_pvtind		 	"Number of Enrollees in Individual Private Insurance (Millions)"
label var numenrollees_pvtothind		"Number of Enrollees in Other Indidivual Private Insurance (Millions)"
label var numenrollees_pvtmedigap		"Number of Enrollees in Medigap (Millions)"
label var numenrollees_pvtemp 			"Number of Enrollees in Employer Sponsored Insurance (Millions)"
label var numenrollees_medicare 		"Number of Enrollees in Medicare (Millions)"
label var numenrollees_medicaid 		"Number of Enrollees in Medicaid (Millions)"
label var numenrollees_CHIP	 			"Number of Enrollees in Children's Health Insurance Program (Millions)"
label var numenrollees_othpub			"Number of Enrollees in Other Public Insurance (Millions)"
label var numenrollees_uninsured		"Number Uninsured (Millions)"

save  "../../2data/NHE2011-num-enrollees.dta", replace

