// Create GDP Deflator Data from BLS Site
// Data Source: http://www.bea.gov/iTable/iTableHtml.cfm?reqid=9&step=3&isuri=1&903=4
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: June 26, 2013


*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
version 11.2
clear

/*
	VARIABLE NOTES: 
		LINK: http://www.bea.gov/iTable/iTableHtml.cfm?reqid=9&step=3&isuri=1&910=X&911=0&903=13&904=2011&905=2013&906=A
		
		Table 1.1.9. Implicit Price Deflators for Gross Domestic Product
		[Index numbers, 2009=100]
		Bureau of Economic Analysis
		Last Revised on: August 29, 2013 - Next Release Date September 26, 2013
*/

clear
insheet using "../../1raw/BEA-gdpdeflator.csv"
						
drop in 1/4
ren v1 line
ren v2 title
foreach var of varlist v3-v86 {
	ren `var' y`=`var'[1]'
}
drop in 1

keep if line == "1"

reshape long y, i(line) j(year)

drop line title
ren y gdp_deflator
destring, replace

label variable gdp_deflator "Implicit Price Deflator for Gross Domestic Product"


save "../../2data/BEA-gdpdeflator.dta"

