// Create US GDP Series By Year
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: September 5, 2013




*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
version 11.2
clear

/*
SOURCE: http://www.bea.gov/iTable/iTableHtml.cfm?reqid=9&step=3&isuri=1&910=X&911=1&903=5&904=2011&905=2013&906=A
Table 1.1.5. Gross Domestic Product
[Billions of dollars]
Bureau of Economic Analysis
Last Revised on: August 29, 2013 - Next Release Date September 26, 2013

Date Downloaded: September 5, 2013 
*/


clear
insheet using "../../1raw/BEA-gdp.csv"
drop in 1/4

ren v1 line
ren v2 name
foreach var of varlist v3-v86{
	ren `var' y`=`var'[1]'
}
drop in 1
destring, replace

reshape long y, i(line) j(year)
keep if line == 1
ren y gdp
replace gdp = gdp*1000
label var gdp "Nominal GDP (Millions)"
drop name line


save "../../2data/BEA-gdp.dta"
