cap program drop recession_line_graph		
program define recession_line_graph
	
	//--TO ADD: 
			//1) Checks for whether dates are in the recessions sample! --//
			//2) Support for alternate date formats
			//3) Slighly bigger shaded areas DONE
			//4) Better relabeling of axis OR better shading. 
			//5) Better line formats!
			//6) Fix error where tmCCYY formats are not used. 
			//7) Minor Fix - Change starting month. 
			
	#delimit ;
	//Recession start and end dates, in the correct Stata format
	local recessionlistNBER `"
		"-688" "-665"
		"-632" "-619"
		"-600" "-576"
		"-564" "-541"
		"-497" "-490"
		"-480" "-462"
		"-440" "-426"
		"-399" "-386"
		"-365" "-322"
		"-272" "-259"
		"-179" "-171"
		"-134" "-123"
		"-78" "-68"
		"-29" "-21"
		"3"   "13"
		"119" "130"
		"166" "182"
		"240" "246"
		"258" "274"
		"366" "374"
		"494" "502"
		"575" "593"
	"';
	//MY OWN LINE COLORS which show better contrast than the stock line colors
	local linecolors `"
		"31 120 180"
		"227 26 28"
		"255 127 0"
		"106 61 154"
		"51 160 44"	
		
		"166 206 227"
		"178 223 138"
		"251 154 153"
		"253 191 111"
		"202 178 214"		
	"'; 
	#delimit cr		

	
	version 11
	
	syntax [if] [in], DATE(varname) GRAPHVars(string asis) ///
			[TWOWAY_options(string asis) LEGEND_options(string asis) zeroline onehundredline ///
			YMIN(real -9999) YMAX(real -9999)]

	marksample touse
	
	// Check date format
	local datefmt: format `date'
	local datefmt = substr("`datefmt'", 1, 3)	
	if !inlist("`datefmt'", "%tm", "%ty") {
		di as error "Format `datefmt' of `date' not supported. Please use %tm or %ty."
		exit 42
	}
	
	// Parse graphvars
	loc nline 0
	while trim(`"`graphvars'"')!= "" {
		loc ++nline 
		
		gettoken vtoken graphvars: graphvars
		gettoken var`nline' vtoken: vtoken
		
		local parsepos = strpos(`"`vtoken'"', ":")
		if `parsepos' != 0 {
			local title`nline' = trim(substr(`"`vtoken'"', 1, `parsepos'-1))
			local options`nline' = substr(`"`vtoken'"', `parsepos'+1, .)
		}
		else{
			local title`nline' = `"`vtoken'"'
			local options`nline'
		}
		
		//tokenize `vtoken', parse(";")
		//local title`nline' = trim("`1'")
		//local options`nline' = "`3'"
		
		//local title`nline' = trim("`title`nline''")
		local sampcond "`sampcond' !missing(`var`nline'')|"
	}
	if `nline' > 10 {
		di as error "Too many variables for custom colors! Using stock colors"
	}
	
	// Check which dates are in sample
	qui sum `date' if `touse' & (`sampcond' 0 )
	local mindt = r(min)
	local maxdt = r(max)
	
	
	// Find height of graph
	forvalues x = 1/`nline' {
		qui sum `var`x'' if `touse' 
		if r(N) == 0 { 
			di as error "Error: `var`x'' only contains missing values!" 
			exit 42
		}
		
		if "`mingph'" == "" {
			local mingph = r(min)
			local maxgph = r(max)
		}
		else{
			if `mingph' > r(min) {
				local mingph = r(min)
			}
			if `maxgph' < r(max) {
				local maxgph = r(max)
			}
		}
	}
	//Stata graphs add buffer region around data points. This enlarges the "recession" regions 
	// based on what I think is the likely correction. 
	local graph_height = (`maxgph'-`mingph')
	//di "PRE: `graph_height' = (`maxgph'-`mingph')/5"
	forvalues x = -5(1)10 {
		loc divisor = 10^(`x')
		loc testeq = `graph_height'/`divisor'
		
		if `testeq' >= 1 & `testeq' < 10 {
			//di "`divisor' `x' `testeq'"
			local nzeros `x'
		}
	}	
	local maxgph = (10^`nzeros')*ceil(`maxgph'/(10^`nzeros'))
	local mingph = (10^`nzeros')*floor(`mingph'/(10^`nzeros'))
	//di "`nzeros' zeros - `graph_height'"
	//di "POST: `graph_height' = (`maxgph'-`mingph')/5"
	
	//Manual override of graph variables
	if `ymin' != -9999 {
		local mingph `ymin'
	}
	if `ymax' != -9999 {
		local maxgph `ymax'
	}

	
	// Write out recessions command
	local nrecess 0
	while trim(`"`recessionlistNBER'"') != "" {
		gettoken recstart 	recessionlistNBER: recessionlistNBER
		gettoken recend		recessionlistNBER: recessionlistNBER
		
		if "`datefmt'" == "%ty" {
			local recstart = `recstart'/12+1960
			local recend = `recend'/12+1960
		}
		
		if (`recstart' < `maxdt') & (`recend' > `mindt') {
			local ++ nrecess
			#delimit ; 
			local cmd_recess `"`cmd_recess' 
				(scatteri `maxgph' `recstart' `maxgph' `recend', 
						color(gs13) lcolor(gs13) recast(area) base(`mingph'))"';			
			#delimit cr
		}
			
	}
	local notherlines 0 
	if "`zeroline'" != "" {
		local ++notherlines
	}
	if "`onehundredline'" != "" {
		local ++notherlines
	}
	
	//Write out graph and legend 
	forvalues x = 1/`nline' {
		gettoken lc linecolors: linecolors
		//Custom palate is limited - use Stata palate if too many vars
		if `nline' <= 10 {
			local cmd_linecolor `"lc("`lc'")"'
		}
		//di `"`x': `cmd_linecolor'"'
		
		local cmd_maingph `"`cmd_maingph' (line `var`x'' `date' if `touse', `cmd_linecolor' `options`x'' )"'
		local cmd_legendlab "`cmd_legendlab' label(`=`nrecess'+`x'+`notherlines'' `title`x'')"
		local cmd_legendorder "`cmd_legendorder' `=`nrecess'+`x'+`notherlines''"
	}
	
	if "`datefmt'" == "%tm" {
		local interval = ceil((`maxdt'-`mindt')/(30*12))
		
		if round((`maxdt'-`mindt')/(`interval'*12)) != ((`maxdt'-`mindt')/`interval'*12) {
			local `maxdt' = `maxdt' - `interval'*12
		}
			
		local cmd_xlab "xlab(`mindt'(`=12*`interval'')`maxdt', angle(vertical) format(%tmCCYY))"
	}
	
	
	if "`datefmt'" == "%ty" {
		local interval = ceil((`maxdt'-`mindt')/30)
		
		if round((`maxdt'-`mindt')/`interval') != ((`maxdt'-`mindt')/`interval') {
			local `maxdt' = `maxdt'-`interval'
		}
		
		local cmd_xlab "xlab(`mindt'(`interval')`maxdt', angle(vertical))"
	}
	
	
	if "`zeroline'" != "" {
		local cmd_line "`cmd_line' (pci 	0 `mindt' 0 `maxdt',  lcolor(gs10))"
	}
	if "`onehundredline'" != "" {
		local cmd_line "`cmd_line' (pci 	100 `mindt' 100 `maxdt',  lcolor(gs10))"
	}

	

	graph twoway `cmd_recess' `cmd_line' `cmd_maingph', ///
			legend(order(`cmd_legendorder') `cmd_legendlab' `legend_options') ///
			 `cmd_xlab' `twoway_options' 
			
end


/*

	macro list
	
	pause on
	pause
	
	
sysuse gnp96.dta, clear

keep if quarter(dofq(date)) == 1
gen date2 = year(dofq(date))
gen date3 = mofd(dofq(date))
format date2 %ty
gen halfgnp = 10000-gnp96

set trace off
#delimit ; 
recession_line_graph if date >= yq(1970, 1) & date < yq(1990, 1),
	date(date2)
	graphvars("gnp96 GNP" "halfgnp GNP divided by two")
	twoway_options(
		ytitle("GNP")
		xtitle("Year")
	
	);
	

#delimit cr
*/



