// Global Table with Overall Growth Rates
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: September 5, 2013


*********************************************************************
********************* GLOBALS AND FLAGS *****************************
*********************************************************************


//Table Characteristics
#delimit ;
local periods
	1990 2001
	2001 2007
	2007 2009
	2009 2012; 
	
local growthvars  
	rtotsp rperscare 
	perpotgdptotsp perpotgdpperscare 
	rpctotsp rpcperscare 
	
	rpemedicare_totsp rpemedicaid_totsp rpvtpremium
	;
#delimit cr


*********************************************************************
*************************** LOAD DATA *******************************
*********************************************************************
clear all
use "../../2data/BEA-gdp.dta", clear
merge 1:1 year using "../../2data/CBO-potentialgdp.dta", nogen 
merge 1:1 year using "../../2data/NHE2011-spending-by-location", nogen
merge 1:1 year using "../../2data/NHE2011-spending-by-payer", nogen
merge 1:1 year using "../../2data/NHE2011-num-enrollees.dta", nogen
merge 1:1 year using "../../2data/KFF-PrivatePremiums.dta", nogen
merge 1:1 year using "../../2data/BEA-gdpdeflator.dta", nogen 
merge 1:1 year using "../../2data/CENSUS-population-totalUS.dta", nogen

*********************************************************************
*********************** GENERATE VARIABLES **************************
*********************************************************************


//Variables to make into real, per capita, values: 
foreach var of varlist totsp perscare {
	gen r`var'	 = `var'*100/(gdp_deflator)
	gen rpc`var' = `var'*100*10^6/(age_all*gdp_deflator)
	
	label variable r`var' "Real `:variable label `var'' (2009 dollars)"
	label variable rpc`var' "Real Per Capita `:variable label `var''"
	
}
gen  rpcpotgdp = rpotgdp*10^6/age_all
label variable rpcpotgdp "Per Capita `:variable label rpotgdp'"

//Per Potential GDP
foreach var of varlist totsp perscare{
	gen perpotgdp`var' = `var'/npotgdp
	label variable perpotgdp`var' "`:variable label `var'' as a Share of Potential GDP"
}

//Per Enrollee
gen rpemedicare_totsp    = insmedicare*100/(numenrollees_medicare*gdp_deflator)
label variable rpemedicare_totsp "Real Per Enrollee Medicare National Health Expenditures"

gen rpemedicaid_totsp	 = insmedicaid*100/(numenrollees_medicaid*gdp_deflator)
label variable rpemedicaid_totsp "Real Per Enrollee Medicaid National Health Expenditures"
						
gen rpvtpremium 	= pvtins_total_premium * 100 / gdp_deflator
label variable rpvtpremium "Real Private Premium"

tsset year, yearly


*********************************************************************
************************* EXTRACT LABELS ****************************
*********************************************************************
foreach var of varlist `growthvars' {
	local `var'_lab: variable label `var'
}



*********************************************************************
************************* CREATE TABLE ******************************
*********************************************************************
tempfile collapsed_global_table

gen i = 1

set trace off
while trim(`"`periods'"') != "" {
	gettoken firstyear periods: periods
	gettoken lastyear periods: periods
	
	local final_reshape_vars g_@`firstyear'`lastyear' @yearfirst`firstyear' @yearlast`lastyear' `final_reshape_vars'
	local collapsevars ""
	
	preserve 
	keep if year >= `firstyear' & year <= `lastyear'  
	
	foreach var of varlist `growthvars'{
 		egen `var'yearfirst`firstyear' = min(year) if !missing(`var')
		egen `var'yearlast`lastyear'  = max(year) if !missing(`var')
		gen `var'valfirst = `var' if `var'yearfirst`firstyear' == year
		gen `var'vallast = `var' if `var'yearlast`lastyear' == year
		
		local collapsevars `collapsevars' `var'valfirst `var'vallast `var'yearfirst`firstyear' `var'yearlast`lastyear'
	}

	collapse (mean) i `collapsevars'

	foreach var of local growthvars{
		gen g_`var'`firstyear'`lastyear' = (`var'vallast/`var'valfirst)^(1/(`var'yearlast`lastyear'-`var'yearfirst`firstyear'))-1
	}
	
	keep i g_* *yearfirst* *yearlast*

	cap merge 1:1 i using `collapsed_global_table', nogen
	save `collapsed_global_table', replace
	
	restore
}
	

*********************************************************************
**************** DISPLAY TABLE (TO COPY TO EXCEL) *******************
*********************************************************************	
	
use `collapsed_global_table', clear

reshape long `final_reshape_vars', i(i) j(var) string
	
order *, alpha
order var
drop i

gen num = .
gen category = "" 
loc n = 1
foreach var of local growthvars{
	replace category = "``var'_lab'" if  var == "`var'"
	replace num = `n' if var == "`var'"
	local ++ n
}
sort num
order num var category

foreach var of varlist g_*{
	replace `var' = 100*`var'
	format `var' %5.0g
}

	
br




//esttab `eqlist' using  "`folder'/latex/`filename'.tex", `estoptions' booktabs `append' `replace'
