// Create global employment wage growth (Yearly) (CPS-MORG)
// Author: Jonathan Holmes
// Created: June 18, 2013

*********************************************************************
********************* GLOBALS AND FLAGS *****************************
*********************************************************************

// PROGRAM FLAGS
global GEN_SAMPLE 				1

#delimit ;
global subsamples `"
	"" "age >= 18 & age <= 64" "Working age adults, 18-64 years old"
	-fullsample "1==1" "All observations in CPS"
"';
#delimit cr

global MORG_OUT "C:\Raw_Data\_Amitabh\CPS_MORG\outdata/"


*********************************************************************
******************* GENERATE CPS-MORG SAMPLE ************************
*********************************************************************
clear all
if ${GEN_SAMPLE} == 1 {
	tempfile merged_collapsed
	cap mkdir "${MORG_OUT}collapsed/"
	local subsmp `"${subsamples}"'
	while trim(`"`subsmp'"') != ""{ 
		gettoken smp_token 	subsmp: subsmp
		gettoken smp_cond 	subsmp: subsmp
		gettoken smp_text	subsmp: subsmp

		save `merged_collapsed', replace emptyok


		forvalues year = 1979/2012 {
			di 
			di "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
			di "LOADING `year'... (`smp_text')"
			di "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
			di

			use "${MORG_OUT}/CPS-MORG-withcodes-`year'.dta", clear
			
			
			*********************************************************************
			***************************** WEIGHTS *******************************
			*********************************************************************
			///////// NOTE - This weight is for the SAMPLE POPULATION ////////////////
			//replace weight = (weight * 20) * 4/12
			//replace earnwt = (earnwt * 20)/12
			
			///////// NOTE - This weight is for the FULL POPULATION ////////////////
			//replace weight = weight * 4/12
			replace earnwt = earnwt/12
			
			*********************************************************************
			************************ SAMPLE CONDITIONS **************************
			*********************************************************************
			keep if `smp_cond'
			//Keep full-time, employed, non self-employed workers
			keep if ftpt == 1 &  lfst == 1 & inlist(sect, 1, 2)
			
			count if missing(earnwke) 
			local num_earnwke_miss = r(N)
			if r(N) > 0 {
				count
				di as error "Sample restrictions are not finding everyone who has missing earnings information"
				di "Number of obs affected: `num_earnwke_miss'/`r(N)' = `=`num_earnwke_miss'/r(N)'"
			}
			
			
			*********************************************************************
			******************* GENERATE VARIABLES AND RESHAPE  *****************
			*********************************************************************
			
			
			keep earnhre earnwke d_hcindr  year intmonth lfst earnwt sect hcoccc
			
			//CONDITION 1: NO LABOR FORCE STATUS
			qui count if earnwt != 0 & missing(lfst)
			if r(N) > 0 {
				di as error "`=r(N)' observations have positive earnwt but no labor force status."
				di as error "Removing..."
				qui replace earnwt = 0 if earnwt > 0 & missing(lfst)
			}
			
			//CONDITION 2: SELF-EMPLOYED WEEKLY EARNINGS
			qui count if earnwke > 0 & sect == 3
			if r(N) > 0 {
				di as error "`=r(N)' observations have positive earnings but are self-employed."
				di as error "Earnings Recoded to zero."
				qui replace earnwke = 0  if earnwke > 0 & sect == 3
			}	

			
			//Generate earnings information 
			gen earnwk_dhealth = earnwke if d_hcindr == 1
			gen earnwk_all = earnwke
			gen all = 1
			
			//COLLAPSE AND RESHAPE
			collapse (median)  earnwk_* (sum) all d_hcindr [pweight=earnwt], by(year)
			
			//MERGE WITH THE REST OF THE DATA
			cap merge 1:1 year using `merged_collapsed'
			cap drop _merge
			save `merged_collapsed', replace

			
		}
		save "${MORG_OUT}/collapsed/wage-growth-yearly`smp_token'-raw", replace 
	}
}
asdf


*********************************************************************
************************ GENERATE GRAPHS ****************************
*********************************************************************
clear 
do "../../0ado/recession_line_graph.ado"
use "${MORG_OUT}collapsed/wage-growth-yearly-raw.dta", clear
merge 1:1 year using "../../2data/BEA-gdpdeflator.dta", nogen 

tsset year 
format year %ty

foreach var of varlist earnwk_* {
	gen r`var' = `var'*100/gdp_deflator
	gen gr`var' = D.`var'/L.`var'
	sum r`var' if year == 2001
	gen r`var'_indx = r`var'*100/r(mean)
}
	
#delimit ;
	recession_line_graph if year >= 1990, date(year)
		graphvars(
			"rearnwk_all  		All Employees"
			"rearnwk_dhealth  	Health Employees"
			)
		twoway_options(
			ytitle("Median Real Self-Reported Weekly Income")
			ylab(550(50)800)
		)
		ymin(550) ymax(800)
		;
#delimit cr

graph export "../../4Output/figa02-median-wage.png", replace width(800) height(600)


