// Convert NYSE Index Data from CSV to .dta 
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: September 4, 2013


*********************************************************************
************************** LOAD DATA ********************************
*********************************************************************

clear all
do "../../0ado/recession_line_graph.ado"

use "../../2data/NYSE-composite-indx.dta"
merge 1:1 date using "../../2data/NYSE-health-indx.dta", nogen

gen mthyr = ym(year(date), month(date))
format mthyr %tm
gen year = year(date)
collapse (mean) nysecomp_totreturn nysehlth_totreturn, by(mthyr year)



foreach var of varlist nysecomp_totreturn nysehlth_totreturn {
	sum `var' if mthyr == ym(2003, 01) 
	gen `var'_indx = `var'/r(mean)
}

*********************************************************************
************************* DRAW GRAPH ********************************
*********************************************************************

#delimit ;
recession_line_graph if year >= 2003, date(mthyr) 
		graphvars(
			"nysecomp_totreturn_indx NYSE Composite Index"
			"nysehlth_totreturn_indx NYSE Health Index"
		)
		twoway_options(
			ytitle("Cumulative Return")
			)
			ymin(0.75) ymax(3);
#delimit cr

graph export "../../4Output/fig09-nyse-returns.png", replace 	width(800) height(600)

