// Create Global CMS-NHE Graphs
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: June 25, 2013


*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
clear all
do "../../0ado/recession_line_graph.ado"
use "../../2data/BEA-gdp.dta", clear
merge 1:1 year using "../../2data/NHE2011-spending-by-payer", nogen
merge 1:1 year using "../../2data/NHE2011-num-enrollees.dta", nogen
merge 1:1 year using "../../2data/BEA-gdpdeflator.dta", nogen 
merge 1:1 year using "../../2data/CENSUS-population-totalUS.dta", nogen
merge 1:1 year using "../../2data/KFF-PrivatePremiums.dta", nogen



*********************************************************************
********************* GENERATE VARIABLES ****************************
*********************************************************************
tsset year
format year %ty

gen rpemedicare_totsp   = insmedicare*100/( numenrollees_medicare*gdp_deflator)
gen rpemedicaid_totsp	= insmedicaid*100/( numenrollees_medicaid*gdp_deflator)
gen rpepvt_totsp 		= inspvt*100/(numenrollees_pvttot*gdp_deflator)

gen rpctotsp = totalsp*10^6*100/(age_all*gdp_deflator)
gen rpvtpremium = pvtins_total_premium * 100 / gdp_deflator

foreach var of varlist rpemedicare_totsp  rpemedicaid_totsp  rpvtpremium  rpepvt_totsp rpctotsp {	
	
	sum `var' if year == 2001
	assert r(N) == 1
	gen trend01_`var' = `var'*100/r(mean)
	
}


*********************************************************************
************************* DRAW GRAPH ********************************
*********************************************************************

#delimit ;
recession_line_graph  if year >= 2001 , date(year) 
	graphvars(
		"trend01_rpemedicare_totsp 		Medicare Per Enrollee"
		"trend01_rpemedicaid_totsp 		Medicaid Per Enrollee"
		"trend01_rpvtpremium 			Average Private Premium"
		"trend01_rpepvt_totsp  			Private Per Enrollee"
		"trend01_rpctotsp 	 			Total Health Per Capita"
		
	)
	twoway_options(
		ytitle("Total Real Health Spending (2001 = 100)")
	)
	onehundredline
;
#delimit cr
graph export "../../4Output/fig07-spending-per-enrollee.png", replace width(800) height(600)
