// Health Employment (CES vs CPS)
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: November 8, 2013


*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
global MORG_OUT "C:\Raw_Data\_Amitabh\CPS_MORG\outdata/"

clear all
do "../../0ado/recession_line_graph.ado"
use "${MORG_OUT}collapsed/absolute-job-growth-monthly-raw.dta", clear
save "${RAW}CPS_MORG/outdata/collapsed/absolute-job-growth-monthly`smp_token'-raw.dta", replace 
gen mthyr = ym(year, intmonth)

merge 1:1 mthyr using "../../2data/BLS-CES-employment.dta"


tsset mthyr, monthly
replace d_hcindr1 = d_hcindr1/1000
replace all1 = all1/1000
tssmooth ma sm_cps_emp_hcindr = d_hcindr1, window(6 1 6)
 
replace sm_cps_emp_hcindr = . if missing(d_hcindr1)

foreach var of varlist  ces_emp_hcindr_sa sm_cps_emp_hcindr {
	gen g_`var' = (`var'-L12.`var')/L12.`var'
}

gen frac_d_hcindr_ces =  ces_emp_hcindr_sa/ces_emp_total_sa
gen frac_d_hcindr_cps =  d_hcindr1/all1



#delimit ;
recession_line_graph if year >= 2001
				, date(mthyr)
			graphvars(
				"g_sm_cps_emp_hcindr Current Population Survey (CPS)"
				"g_ces_emp_hcindr_sa Current Employment Statistics (CES)"
				"frac_d_hcindr_ces Fraction Employed (CES): yaxis(2)"
			)
			twoway_options(
				ytitle("Yearly Employment Growth (Health Sector)")
				ytitle("Fraction Employed in Health Sector (CES)", axis(2))
				xtitle("")
			)
			legend_options(
				cols(1)
			)
			zeroline ymin(-.01) ymax(0.06); 
#delimit cr

graph export "../../4Output/fig04-health-employment.png", width(800) height(600) replace 

