// Spending vs. Potential GDP
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: September 5, 2013


*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
clear all
do "../../0ado/recession_line_graph.ado"
use "../../2data/BEA-gdp.dta", clear
merge 1:1 year using "../../2data/NHE2011-spending-by-location", nogen
merge 1:1 year using "../../2data/CBO-potentialgdp.dta", nogen 
merge m:1 year using "../../2data/CENSUS-population-totalUS.dta", nogen

tsset year, yearly

foreach var of varlist totsp perscare {
	gen perpotgdp`var' = `var'/npotgdp
	gen g`var' = D.`var'/L.`var'
	gen gperpotgdp`var' = D.perpotgdp`var'/L.perpotgdp`var'
}	



#delimit ;
recession_line_graph if year >= 1970 & year <= 2012
				, date(year)
			graphvars(
				"perpotgdptotsp Total Spending"
				"perpotgdpperscare Personal Spending"

			)
			twoway_options(
				ytitle("Health Spending as a Fraction of Potential GDP")
			)
			;
#delimit cr
graph export "../../4Output/fig02a-total-personal-vs-potential-gdp.png", replace width(800) height(600)


#delimit ;
recession_line_graph if year >= 1970 & year <= 2012
				, date(year)
			graphvars(
				"gperpotgdptotsp Total Spending"
				"gperpotgdpperscare Personal Spending"
				
			)
			twoway_options(
				ytitle("Yearly Growth in Health Spending" "as a Fraction of Potential GDP")
			)
			zeroline
			;
#delimit cr
graph export "../../4Output/fig02b-growth-total-personal-vs-potential-gdp.png", replace width(800) height(600)
