// Fuchs Replication
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: August 30, 2013

*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************

clear all

do "../../0ado/recession_line_graph.ado"
use "../../2data/Atlarum-NHEmonthly.dta"
merge 1:1 mthyr using "../../2data/MA-Monthly-GDP.dta", nogen

drop gdp 
ren monthlynominalgdpindex gdp
ren monthlyrealgdpindex rgdp
gen gdp_deflator =gdp*100/rgdp
gen rtotsp = totsp*100/gdp_deflator

tsset mthyr, monthly
foreach var of varlist rgdp rtotsp {
	gen g_`var' = (`var'-L12.`var')/L12.`var'
}

lpoly g_rgdp mthyr, bw(2) gen(sm_g_rgdp) at(mthyr)
lpoly g_rtotsp mthyr, bw(2) gen(sm_g_rtotsp) at(mthyr)

gen nhe_minus_gdp = sm_g_rtotsp-sm_g_rgdp




*********************************************************************
************************* DRAW GRAPHS *******************************
*********************************************************************

/*

gen g_gdp_smaller 	= sm_g_rgdp if sm_g_rgdp < sm_g_rtotsp
gen g_gdp_bigger 	= sm_g_rgdp if sm_g_rgdp > sm_g_rtotsp
gen g_totsp_smaller = sm_g_rtotsp if sm_g_rgdp > sm_g_rtotsp
gen g_totsp_bigger 	= sm_g_rtotsp if sm_g_rgdp < sm_g_rtotsp

#delimit ;
twoway 
		(pci 	0 396 0 642,  lcolor(gs10))
		
		(rarea g_gdp_smaller g_totsp_bigger mthyr, cmissing(n) color(ltblue)) 
		(rarea g_gdp_bigger g_totsp_smaller mthyr, cmissing(n) color(orange_red))
		
		(line sm_g_rtotsp mthyr, lw(.25) lc(blue)) 
		(line sm_g_rgdp mthyr, lw(.25) lc(red))
		if year >= 1993, 
		legend(
			label(4 "Real National Health Expenditures")
			label(5 "Real GDP")
			order(5 4)
			cols(1))
		ytitle("Yearly Growth Rate (Smoothed)")
		xtitle("")
		//xlab(336(12)642, angle(vertical) format(%tmCCYY))
		xlab(396(12)642, angle(vertical) format(%tmCCYY))
		;
#delimit cr
graph export "../../4Output/fig01b-nhe-over-gdp-area.png", width(800) height(600) replace 	
*/

#delimit ;
recession_line_graph if year >= 1993, date(mthyr)
	graphvars(
		"sm_g_rgdp Real GDP: lw(.5)"
		"sm_g_rtotsp Real NHE: lw(.5)"
	)
	zeroline
	twoway_options(
		ytitle("Yearly Growth Rate (Smoothed)")
		yl(-.04(.02).1)
	)

	ymin(-.04) ymax(0.1) ;
#delimit cr
graph export "../../4Output/fig01-fuchs_replication.png", width(800) height(600) replace 	



#delimit ;
recession_line_graph if year >= 2007, date(mthyr)
	graphvars(
		"sm_g_rgdp Real GDP "
		"sm_g_rtotsp Real NHE"
		
		"nhe_minus_gdp Difference"
	)
	zeroline
	twoway_options(
		ytitle("Yearly Growth Rate (Smoothed)")
	)
	ymin(-.05) ymax(0.1);
#delimit cr
graph export "../../4Output/fig10-nhe-over-gdp-line.png", width(800) height(600) replace 	
