// Fuchs Replication
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: August 30, 2013



*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
clear all
do "../../0ado/recession_line_graph.ado"
use "../../2data/BEA-gdp.dta", clear
merge 1:1 year using "../../2data/NHE2011-spending-by-location", nogen
merge 1:1 year using "../../2data/BEA-gdpdeflator.dta", nogen 
merge 1:1 year using "../../2data/CENSUS-population-totalUS.dta", nogen

tsset year, yearly

foreach var of varlist gdp totsp perscare{
	// SPENDING VARS
	gen pc`var' 	= `var'*10^6/age_all
	gen r`var' 		= `var'*100/gdp_deflator
	gen rpc`var'	= r`var'*10^6/age_all

	// GROWTH RATE IN SPENDING
	gen g_`var' 	= D.`var'/L.`var'
	gen g_pc`var' 	= D.pc`var'/L.pc`var'
	gen g_r`var' 	= D.r`var'/L.r`var'
	gen g_rpc`var' 	= D.rpc`var'/L.rpc`var'
}

	
// 5-YEAR MOVING AVERAGE GROWTH RATE IN SPENDING
tssmooth ma g_rpctotsp_MA5yr = g_rpctotsp if !missing(g_rpctotsp), window(2 1 2)	 
tssmooth ma g_rpcgdp_MA5yr = g_rpcgdp if !missing(g_rpcgdp), window(2 1 2)
gen g_rpcgdp_MA5yr_plus24 = g_rpcgdp_MA5yr + .024


#delimit ;
recession_line_graph if year >= 1970, date(year)
	graphvars(
		`"g_rpcgdp_MA5yr_plus24 GDP Plus 2.4%"'
		"g_rpctotsp_MA5yr 	Health Spending"
	)
	twoway_options(
		xlabel(1970(5)2010) ylabel(0(.01).07) xlab(1970(2)2012)
		ytitle("Real Per Capita Growth Rate")
	)
	ymin(0)
	;
#delimit cr		
graph export "../../4Output/fig01-fuchs_replication.png", width(800) height(600) replace 	

////////////////TESTING////////////////////////
ren totsp dump

merge 1:m year using "../../2data/Atlarum-NHEmonthly.dta", nogen
replace mthyr = ym(year, 06) if missing(mthyr)
merge 1:1 mthyr using "../../2data/MA-Monthly-GDP.dta", nogen

drop gdp 
ren monthlynominalgdpindex gdp_monthly
ren monthlyrealgdpindex rgdp_monthly
gen gdp_deflator_monthly =gdp_monthly*100/rgdp_monthly
gen rtotsp_monthly = totsp*100/gdp_deflator_monthly

tsset mthyr, monthly
foreach var of varlist rgdp_monthly rtotsp_monthly {
	gen g_`var' = (`var'-L12.`var')/L12.`var'
}
//tssmooth ma sm_g_gdp = g_gdp, weights(1 1 1 1 <1> 1 1 1 1)
//tssmooth ma sm_g_totsp = g_totsp, weights(1 1 1 1 <1> 1 1 1 1)

lpoly g_rgdp_monthly mthyr, bw(2) gen(sm_g_rgdp) at(mthyr)
lpoly g_rtotsp_monthly mthyr, bw(2) gen(sm_g_rtotsp) at(mthyr)

gen sm_g_rgdp_plus24 = sm_g_rgdp + .024


#delimit ;
recession_line_graph if year >= 1970 & year <= 2013, date(mthyr)
	graphvars(
		`"g_rpcgdp_MA5yr_plus24 Fuchs GDP Plus 2.4%"'
		"sm_g_rgdp_plus24 Monthly Real GDP plus 2.4%"
		
		
	)
	twoway_options(
		ytitle("Real Per Capita Growth Rate")
	)
	ymin(0)
	;
#delimit cr	


#delimit ;
recession_line_graph if year >= 1970 & year <= 2013, date(mthyr)
	graphvars(
"g_rpctotsp_MA5yr 	Fuchs Health Spending"
"sm_g_rtotsp Monthly Real NHE"
		
		
	)
	twoway_options(
		ytitle("Real Per Capita Growth Rate")
	)
	ymin(0)
	;
#delimit cr	

