// Create expenditure tables from CMS Expenditure Data
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: August 20, 2013



*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
clear
insheet using "../../1raw/NHE2011-spending.csv"

//Make a whole bunch of changes necessary because of faulty import (shouldn't have used CSV...)
replace title1 = "" if title1 == "Total CMS Programs (Medicaid"
replace title2 = "Total CMS Programs (Medicaid, CHIP and Medicare)" if title2 == "CHIP and Medicare)"
replace title1 = "Population (Millions)" if title1 == "POPULATION"
replace title2 = "Federal Funds" if title1 == "Federal Funds"
replace title2 = "State/Local Funds" if title1 == "State/Local Funds"
replace title1 = "" if title1 == "Federal Funds"
replace title1 = "" if title1 == "State/Local Funds"
replace title2 = "" if title1 == "Total Other Health"
replace title3 = "" if title1 == "Total Other Health"
replace title1 = "Total Other Health, Residential, and Personal Care Expenditures" if title1 == "Total Other Health"

//Ensure I am good 
count if (!missing(title1) + !missing(title2) + !missing(title3) + !missing(title4) + !missing(title5)) > 1
if r(N) > 0 {
	di as error "PROBLEM WITH CODE." 
	exit 42
}

//Looks like title3 and title4 are the same "level." 
replace title3 = title4 if missing(title3)
drop title4
ren title5 title4

//"FILL DOWN"
replace title3 = title3[_n-1] if missing(title3) & !missing(title4)
replace title2 = title2[_n-1] if missing(title2) & missing(title3) & !missing(title4)
replace title2 = title2[_n-1] if missing(title2) & missing(title1)
replace title1 = title1[_n-1] if missing(title1) 	

//Identify totals
replace title2 = "TOTAL" if missing(title2)
replace title3 = "TOTAL" if missing(title3) & title2 != "TOTAL"
replace title4 = "TOTAL" if missing(title4) & !inlist(title3, "TOTAL", "")



preserve

keep if title2 == "TOTAL"
drop title2 title3 title4 oldtitle

gen category = _n
local numvars = _N

gen varn =  "" 
replace varn = "totsp"			if title1 == "Total National Health Expenditures"
replace varn = "pop"			if title1 == "Population (Millions)"
replace varn = "consumption"	if title1 == "Health Consumption Expenditures"
replace varn = "perscare"		if title1 == "Personal Health Care"
replace varn = "hosp" 			if title1 == "Total Hospital Expenditures"
replace varn = "physician"		if title1 == "Total Physician and Clinical Expenditures"
replace varn = "dental"			if title1 == "Total Dental Services Expenditures"
replace varn = "oprofessional"	if title1 == "Total Other Professional Services Expenditures"
replace varn = "homehealth"		if title1 == "Total Home Health Care Expenditures"
replace varn = "othproducts"	if title1 == "Total Non-Durable Medical Products Expenditures"
replace varn = "prescription"	if title1 == "Total Prescription Drug Expenditures"
replace varn = "dme"			if title1 == "Total Durable Medical Equipment Expenditures"
replace varn = "nursing"		if title1 == "Total Nursing Care Facilities and Continuing Care Retirement Communities"
replace varn = "ocare"			if title1 == "Total Other Health, Residential, and Personal Care Expenditures"
replace varn = "totadmin"		if title1 == "Total Administration and Total Net Cost of Health Insurance Expenditures"
replace varn = "stateadmin"		if title1 == "State and Local  Administration Expenditures"
replace varn = "fedadmin"		if title1 == "Federal Administration Expenditures"
replace varn = "pvtinsure"		if title1 == "Net Cost of Health Insurance Expenditures"
replace varn = "pubhlth"		if title1 == "Public Health Activity"
replace varn = "research"		if title1 == "Research"
replace varn = "struct_equip"	if title1 == "Total Structures and Equipment"

forvalues x = 1/`numvars' {
	local cat`x' = title1[`x']
	local varn`x' = varn[`x']
}



drop title1 varn

reshape long year, i(category) j(yr)
rename year sum
rename yr year
sort year category

reshape wide sum, i(year) j(category)

forvalues x = 1/`numvars' {
	label 	variable sum`x' "`cat`x''"
	char define sum`x'[units] "Millions"
	ren 	sum`x' `varn`x''
	
}


set obs `=_N+1'
replace year = 2012 if missing(year)
replace totsp= 2828917 if year == 2012 
replace perscare = 2387500 if year == 2012

char define totsp[note] "2012 value average of Altarum monthly series." 
char define perscare[note] "2012 value average of Altarum monthly series." 

save "../../2data/NHE2011-spending-by-location", replace
restore	




preserve

keep if title1 == "Total National Health Expenditures"
drop oldtitle
drop title1
gen cat = ""
order cat

replace cat = "totalsp" 	if title2 == "TOTAL"
replace cat = "oop" 		if title2 == "Out of pocket"
replace cat = "ins" 		if title2 == "Health Insurance"
replace cat = "othpayer" 	if title2 == "Other Third Party Payers and Programs"
replace cat = "pubhlth" 	if title2 == "Public Health Activity"
replace cat = "invest" 		if title2 == "Investment"

drop title2
drop if missing(cat)
drop if cat == "othpayer" & title3 != "TOTAL"
drop if cat == "invest"   & title3 != "TOTAL"
drop if cat == "pubhlth"  & !missing(title4)
drop if cat == "ins" 	  & !inlist(title4, "TOTAL")

replace cat = "inspvt" if title3 == "Private Health Insurance"
replace cat = "insmedicare" if title3 == "Medicare"
replace cat = "insmedicaid" if title3 == "Medicaid (Title XIX)"
replace cat = "ins" 	if title3 == "CHIP (Title XIX and Title XXI)"

collapse (sum) year*, by(cat)
replace cat = "insothgvt" if cat == "ins"

reshape long year, i(cat) j(yr)
reshape wide year, i(yr) j(cat) string

foreach var of varlist year* {
	rename `var' `=subinstr("`var'", "year", "", 1)'
}
rename yr year

label variable insmedicaid "Total National Medicaid Expenditures"
label variable insmedicare  "Total National Medicare Expenditures"
label variable insothgvt  "Total National Expenditures by Other Governments"
label variable inspvt  "Total National Private Expenditures"
label variable invest  "Total National Investment Expenditures"
label variable oop  "Total National Out of Pocket Expenditures"
label variable othpayer	 "Total National Expenditures by Other Payers"
label variable pubhlth  "Total National Public Health Expenditures"
label variable totalsp  "Total National Health Expenditures"


set obs `=_N+1'
replace year = 2012 if missing(year)
replace totalsp= 2828917 if year == 2012 


char define totalsp[note] "2012 value average of Altarum monthly series." 


save "../../2data/NHE2011-spending-by-payer", replace
restore




/*
preserve
keep if title1 == "Personal Health Care"

drop oldtitle
drop title1
gen cat = ""
order cat

replace cat = "totalsp" 	if title2 == "TOTAL"
replace cat = "oop" 		if title2 == "Out of pocket"
replace cat = "ins" 		if title2 == "Health Insurance"
replace cat = "othpayer" 	if title2 == "Other Third Party Payers and Programs"
replace cat = "pubhlth" 	if title2 == "Public Health Activity"
replace cat = "invest" 		if title2 == "Investment"

drop title2
drop if missing(cat)
drop if cat == "othpayer" & title3 != "TOTAL"
drop if cat == "invest"   & title3 != "TOTAL"
drop if cat == "pubhlth"  & !missing(title4)
drop if cat == "ins" 	  & !inlist(title4, "TOTAL")

replace cat = "inspvt" if title3 == "Private Health Insurance"
replace cat = "insmedicare" if title3 == "Medicare"
replace cat = "insmedicaid" if title3 == "Medicaid (Title XIX)"
replace cat = "ins" 	if title3 == "CHIP (Title XIX and Title XXI)"

collapse (sum) year*, by(cat)
replace cat = "insothgvt" if cat == "ins"

reshape long year, i(cat) j(yr)
reshape wide year, i(yr) j(cat) string

foreach var of varlist year* {
	rename `var' `=subinstr("`var'", "year", "", 1)'
}
rename yr year

foreach var of varlist insmedicaid-totalsp {
	ren `var' `var'_perscare
}	

label variable insmedicaid_perscare "Personal Medicaid Expenditures"
label variable insmedicare_perscare "Personal Medicare Expenditures"
label variable insothgvt_perscare  	"Personal Expenditures by Other Governments"
label variable inspvt_perscare  	"Personal Private Expenditures"
label variable oop_perscare  		"Personal Out of Pocket Expenditures"
label variable othpayer_perscare	"Personal Expenditures by Other Payers"
label variable totalsp_perscare  	"Personal Health Expenditures"
	

save "${SPENDING_RAW}NHE-BY-PAYER-PERSONAL", replace
restore
*/

preserve
keep if title1 == "Total Prescription Drug Expenditures"

drop oldtitle
drop title1
gen cat = ""
order cat

replace cat = "totalsp" 	if title2 == "TOTAL"
replace cat = "oop" 		if title2 == "Out of pocket"
replace cat = "ins" 		if title2 == "Health Insurance"
replace cat = "othpayer" 	if title2 == "Other Third Party Payers and Programs"
replace cat = "pubhlth" 	if title2 == "Public Health Activity"
replace cat = "invest" 		if title2 == "Investment"

drop title2
drop if missing(cat)
drop if cat == "othpayer" & title3 != "TOTAL"
drop if cat == "invest"   & title3 != "TOTAL"
drop if cat == "pubhlth"  & !missing(title4)
drop if cat == "ins" 	  & !inlist(title4, "TOTAL")

replace cat = "inspvt" if title3 == "Private Health Insurance"
replace cat = "insmedicare" if title3 == "Medicare"
replace cat = "insmedicaid" if title3 == "Medicaid (Title XIX)"
replace cat = "ins" 	if title3 == "CHIP (Title XIX and Title XXI)"

collapse (sum) year*, by(cat)
replace cat = "insothgvt" if cat == "ins"

reshape long year, i(cat) j(yr)
reshape wide year, i(yr) j(cat) string

foreach var of varlist year* {
	rename `var' `=subinstr("`var'", "year", "", 1)'
}
rename yr year

foreach var of varlist insmedicaid-totalsp {
	ren `var' `var'_drug
}	


label variable insmedicaid_drug "Medicaid Prescription Drug Expenditures"
label variable insmedicare_drug "Medicare Prescription Drug Expenditures"
label variable insothgvt_drug  	"Prescription Drug Expenditures by Other Governments"
label variable inspvt_drug  	"Private Prescription Drug Expenditures"
label variable oop_drug  		"Out of Pocket Prescription Drug Expenditures"
label variable othpayer_drug	"Expenditures for Prescription Drugs by Other Payers"
label variable totalsp_drug  	"Total Prescription Drug Expenditures"



save "../../2data/NHE2011-spending-by-payer-prescription", replace
restore

