// Code for Variables (CPS-MORG)
// Used for CPS-MORG
// Author: Jonathan Holmes
// Created: May 21, 2013

*********************************************************************
********************* GLOBALS AND FLAGS *****************************
*********************************************************************
//HOUSEKEEPING
clear all 
set mem 2000M

//PROGRAM FLAGS
global GEN_YEARLY_SAMPLES 	1


/*NOTE:
	This file requires CPS MORG data from the NBER, which is available at 
	http://www.nber.org/data/morg.html. The raw files should be copied to 
	$MORG_RAW and should be the only data files in this folder for this code
	to be run properly. 
	*/
	


global MORG_RAW "C:\Raw_Data\_Amitabh\CPS_MORG\data/"
global MORG_OUT "C:\Raw_Data\_Amitabh\CPS_MORG\outdata/"

*********************************************************************
********************* VARIABLES TO USE ******************************
*********************************************************************

#delimit ;
local keepvars 
	year intmonth
	hhid recnum								/* ID variables*/	
	weight weightp 	cmpwgt earnwt earnwtp	/* Weights */
	cbsafips state							/* Regions */
	
	sex age	race ethnic	marital 			/* Demographics */
	gradeat gradecp grade92
	
	ind02 ind70 ind80						/* Industry variables */
	occ00 occ2011 occ70 occ80 				/* Occupation variables */
	class94 classer class					/* Worker Class/Sector */
	esr lfsr89 lfsr94						/* Employment characteristics */
	ftpt79 ftpt89 ftpt94					
	
	paidhr paidhre earnhr earnhre 			/* Earnings Information */
	uearnwk uearnwke earnwke 				
	l25a l25b l25c l25d
	
	uhourse hourslw reason94 				/* Hours of Work */			
	;
#delimit cr



if ${GEN_YEARLY_SAMPLES} == 1 {
	local dta_files: dir "${MORG_RAW}" files "*.dta"
	di `"`dta_files'"'

	foreach fi of local dta_files {
		di 
		di "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
		di "%% Adding `fi'..."
		di "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
		
		*********************************************************************
		************* LOAD DATA AND KEEP ONLY RELEVANT VARS *****************
		*********************************************************************
		
		use "${MORG_RAW}`fi'", clear
		
		qui{
			//Keep only relevant variables, reducing the size of the ultimate dataset. 
			ds
			local currvars `r(varlist)'
			local kp : list keepvars & currvars	
			keep `kp'
			
			levelsof year, loc(year)
			if `year'== 1983 {
				drop ind70 //Appears to be miscoded! 95% of the sample is computer programmers... 
			}
			
			
			*********************************************************************
			************************ CODE INDUSTRIES ****************************
			*********************************************************************

			//Code Industries and occupations
			do "_Code-ind-occ.do"
			
			
			
			*********************************************************************
			********************** LABOR FORCE STATUS ***************************
			*********************************************************************
			/*	Adding labor force statistics 		*/
			//BREAKS IN DATA SERIES: 
			//1 - '88-'89
			//2 - '93-94
			
			#delimit ; 
			label define lfst
				1 "Employed"
				2 "Unemployed"
				3 "Not in the Labor Force";
			#delimit cr

			gen byte lfst = . 
			
			cap confirm var esr
			if !_rc{
				replace lfst = 1 if inlist(esr, 1, 2)
				replace lfst = 2 if inlist(esr, 3)
				replace lfst = 3 if inlist(esr, 4, 5, 6, 7)
			}
			
			cap confirm var lfsr89
			if !_rc{
				replace lfst = 1 if inlist(lfsr89, 1, 2)
				replace lfst = 2 if inlist(lfsr89, 3, 4)
				replace lfst = 3 if inlist(lfsr89, 5, 6, 7)
			}
			
			cap confirm var lfsr94
			if !_rc{
				replace lfst = 1 if inlist(lfsr94, 1, 2)
				replace lfst = 2 if inlist(lfsr94, 3, 4)
				replace lfst = 3 if inlist(lfsr94, 5, 6, 7)
			}
			label variable lfst "Labor force status"
			label values lfst lfst
			
			*********************************************************************
			************************ CLASS OF WORKER ****************************
			*********************************************************************
			#delimit ; 
			label define class
				1 "Private, for profit"
				2 "Government"
				3 "Self-Employed"
				4 "Without Pay"
				5 "Never worked full time"
				;
			#delimit cr
			
			gen byte sect = . 
			
			//Prevent Stata error with abbreviations
			cap confirm var class, exact
			if !_rc ren class class79
			
			cap confirm var class94
			if !_rc{
				replace sect = 1 if inlist(class94, 4, 5)
				replace sect = 2 if inlist(class94, 1, 2, 3)
				replace sect = 3 if inlist(class94, 6, 7)
				replace sect = 4 if inlist(class94, 8)
				replace sect = 5 if missing(class94)
			}

			cap confirm var classer
			if !_rc{
				replace sect = 1 if inlist(classer, 1)
				replace sect = 2 if inlist(classer, 2, 3, 4)
				replace sect = 3 if inlist(classer, 5, 6)
				replace sect = 4 if inlist(classer, 7)
				replace sect = 5 if inlist(classer, 8)
			}
			else {
				cap confirm var class79
				if !_rc{
					replace sect = 1 if inlist(class79, 1)
					replace sect = 2 if inlist(class79, 2, 3, 4)
					replace sect = 3 if inlist(class79, 5, 6)
					replace sect = 4 if inlist(class79, 7)
					replace sect = 5 if inlist(class79, 8)
				}
			
			}
			label variable sect "Class of Worker"
			label values sect class
			
			
			*********************************************************************
			********************* FULL-TIME / PART-TIME *************************
			*********************************************************************
			#delimit ; 
			label define ftpt
				1 "Full-Time"
				2 "Part-Time"
				3 "Not in Labor Force"
				;
			#delimit cr
			
			gen byte ftpt = . 
			
			cap confirm var ftpt79
			if !_rc{
				replace ftpt = 1 if inlist(ftpt79, 1, 3)
				replace ftpt = 2 if inlist(ftpt79, 2, 4, 5)
				replace ftpt = 3 if inlist(ftpt79, 0)
			}
			
			cap confirm var ftpt89
			if !_rc{
				replace ftpt = 1 if inlist(ftpt89, 2, 6)
				replace ftpt = 2 if inlist(ftpt89, 3, 4, 5, 7)
				replace ftpt = 3 if inlist(ftpt89, 1)
			}			
			
			cap confirm var ftpt94
			if !_rc{
				replace ftpt = 1 if inlist(ftpt94, 2, 5, 8, 9, 11)
				replace ftpt = 2 if inlist(ftpt94, 3, 4, 6, 7, 10, 12)
				replace ftpt = 3 if inlist(ftpt94, 1)
			}		
			label variable ftpt "Full-Time/Part-Time Status"
			label values ftpt ftpt
			
			
			*********************************************************************
			*************************** EDUCATION *******************************
			*********************************************************************
			
			#delimit ; 
			label define educ
				1 "Less Than High School"
				2 "Completed High School"
				3 "One or More Years of College"
				;
			#delimit cr
			
			gen byte educ = . 
			
			cap confirm var grade92
			if !_rc{
				replace educ = 1 if grade92 < 39 & !missing(grade92)
				replace educ = 2 if grade92 == 39
				replace educ = 3 if grade92 > 39 & !missing(grade92)
			}
			cap confirm var gradeat
			if !_rc{
				replace educ = 1 if (gradeat < 12 | ((gradeat == 12) & (gradecp == 2))) & !missing(gradeat) 
				replace educ = 2 if ((gradeat == 12) & (gradecp == 1)) & !missing(gradeat) 
				replace educ = 3 if (gradeat > 12)  & !missing(gradeat)
			}
			label values educ educ
			
			
			*********************************************************************
			*********************** OTHER VARIABLES *****************************
			*********************************************************************
			gen white = (race == 1)
			gen black = (race == 2)
			
			label define sex 1 "Male" 2 "Female"
			label values sex sex
			
			
			levelsof year, local(yr)
			
			compress
		}
		save "${MORG_OUT}CPS-MORG-withcodes-`yr'.dta", replace
		
	}
}


