// Clean up the Private Insurance Payment Info
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: August 27, 2013


*********************************************************************
*************************** DATA NOTES ******************************
*********************************************************************

/*
Average Annual Worker and Employer Contributions to Premiums 
and Total Premiums for Single Coverage, 1999-2013
SOURCE CITED: Kaiser/HRET Survey of Employer-Sponsored Health Benefits, 1999-2013.
Exhibit 6.3; P. 72

Exhibit From: 
THE KAISER FAMILY FOUNDATION - AND - HEALTH RESEARCH & EDUCATIONAL TRUST, Employer Health Benefits 2013 Annual Survey
http://kaiserfamilyfoundation.files.wordpress.com/2013/08/8465-employer-health-benefits-20131.pdf
Accessed: August 27, 2013
*/

*********************************************************************
***************** LOAD MOST RECENT PREMIUMS DATA *******************
*********************************************************************

version 11.2
clear all
insheet using "../../1raw/KFF-PrivatePremiums.csv"

drop if missing(v2)

foreach var of varlist v1-v4{
	ren `var' `=`var'[1]'
}

drop in 1
destring, replace

ren worker_contribution pvtins_worker_premium
ren employer_contribution pvtins_emp_premium
ren total_premium pvtins_total_premium

save "../../2data/KFF-PrivatePremiums.dta", replace
