// Create global employment growth tables (Monthly) (CPS-MORG)
// Author: Jonathan Holmes
// Created: June 18, 2013


*********************************************************************
********************* GLOBALS AND FLAGS *****************************
*********************************************************************

// HOUSEKEEPING
clear all
set mem 1500M

// PROGRAM FLAGS
global GEN_SAMPLE 				1


local keepvars all d_hcindr earnwke

#delimit ;
global subsamples `"
	"" "age >= 18 & age <= 64" "Working age adults, 18-64 years old"
	-fullsample "1==1" "All observations in CPS"
"';
#delimit cr

global MORG_OUT "C:\Raw_Data\_Amitabh\CPS_MORG\outdata/"

*********************************************************************
******************* GENERATE CPS-MORG SAMPLE ************************
*********************************************************************


if ${GEN_SAMPLE} == 1 {
	cap mkdir "${MORG_OUT}collapsed/"
	local subsmp `"${subsamples}"'
	while trim(`"`subsmp'"') != ""{ 
		gettoken smp_token 	subsmp: subsmp
		gettoken smp_cond 	subsmp: subsmp
		gettoken smp_text	subsmp: subsmp

		save "${MORG_OUT}collapsed/absolute-job-growth-monthly`smp_token'-raw.dta", replace emptyok


		forvalues year = 1979/2012 {
			di 
			di "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
			di "LOADING `year'... (`smp_text')"
			di "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
			di

			use "${MORG_OUT}CPS-MORG-withcodes-`year'.dta", clear
			
			
			*********************************************************************
			***************************** WEIGHTS *******************************
			*********************************************************************
			///////// NOTE - This weight is for the SAMPLE POPULATION ////////////////
			//replace weight = (weight * 20) * 4
			//replace earnwt = (earnwt * 20)
			
			///////// NOTE - This weight is for the FULL POPULATION ////////////////
			//replace weight = weight * 4
			//replace earnwt = earnwt
			
			*********************************************************************
			************************ SAMPLE CONDITIONS **************************
			*********************************************************************
			keep if `smp_cond'
			
			
			*********************************************************************
			******************* GENERATE VARIABLES AND RESHAPE  *****************
			*********************************************************************
			cap catdummies lfst, gen(lfst_)
			
			gen all = 1
			gen all_restrict = !indmiss if !missing(indmiss)
			label variable all "All Industries"
						
			
			/*				RESHAPE DATA TO SHOW TRENDS 			*/	
			foreach var of varlist `keepvars' {
				local `var'_lab: variable label `var'
			}
			keep `keepvars' year intmonth lfst earnwt sect 
			
			//CONDITION 1: NO LABOR FORCE STATUS
			qui count if earnwt != 0 & missing(lfst)
			if r(N) > 0 {
				di as error "`=r(N)' observations have positive earnwt but no labor force status."
				di as error "Removing..."
				qui replace earnwt = 0 if earnwt > 0 & missing(lfst)
			}
			
			//CONDITION 2: SELF-EMPLOYED WEEKLY EARNINGS
			qui count if earnwke > 0 & sect == 3
			if r(N) > 0 {
				di as error "`=r(N)' observations have positive earnings but are self-employed."
				di as error "Earnings Recoded to zero."
				qui replace earnwke = 0  if earnwke > 0 & sect == 3
			}	
						
			
			//COLLAPSE AND RESHAPE
			collapse (sum) `keepvars'  [pweight=earnwt], by(year intmonth lfst)
			reshape wide `keepvars', i(year intmonth) j(lfst)
			
			foreach var in `keepvars' {
				local status_list "Employed Unemployed NILF"
				forvalues x = 1/3 {
						gettoken status status_list: status_list			
						
						cap gen `var'`x' = . 
						label variable `var'`x' "``var'_lab' (`status')"
				}
			}	
			
			//MERGE WITH THE REST OF THE DATA
			cap merge 1:1 year intmonth using "${MORG_OUT}collapsed/absolute-job-growth-monthly`smp_token'-raw.dta"
			cap drop _merge
			save "${MORG_OUT}collapsed/absolute-job-growth-monthly`smp_token'-raw.dta", replace 
			
		}
	}
}




