// Convert CBO GDP Projections from CSV to .dta
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: August 13, 2013


*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************

clear
insheet using "../../1raw/CBO-potentialgdp.csv"

/* DATA NOTES: 
This file presents data that supplements information in CBO's February 2013 report The Budget and Economic Outlook: Fiscal Years 2013 to 2023.
Source: Congressional Budget Office, The Budget and Economic Outlook: Fiscal Years 2013 to 2023, January 2013.
Note: Real potential GDP is expressed in chained 2005 dollars.
http://www.cbo.gov/publication/43903
Retrieved August 21, 2010 */

drop v7-v15
ren v2 rpotgdp
ren v3 npotgdp
ren v5 nairu_lt
ren v6 nairu_st
drop v4 v16
ren v1 quarterstr
drop if length(quarterstr) != 6

destring, replace ignore(",")
compress

gen year = year(dofq(quarterly(quarterstr, "YQ")))

collapse (mean) rpotgdp npotgdp, by(year)

replace rpotgdp = rpotgdp * 1000
replace npotgdp = npotgdp * 1000
label variable rpotgdp "Real Potential GDP (Millions, 2005 Chained Dollars, Average of Quarterly Data)"
label variable npotgdp "Nominal Potential GDP (Millions, Average of Quarterly Data)"
save "../../2data/CBO-potentialgdp.dta", replace

