// Create CES Employment Series By Year
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: November 8, 2013


*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************

version 11.2

tempfile health_nsa health_sa total_nsa 

clear

/*
SOURCE: http://data.bls.gov/cgi-bin/dsrv?ce
Employment, Hours, and Earnings from the Current Employment Statistics survey (National) 

Series Id:	CEU6562000101				
Not Seasonally Adjusted					
Super Sector:	Education and health services				
Industry:	Health care				
NAICS Code:	621,2,3				
Data Type:	ALL EMPLOYEES, THOUSANDS				
Years:	1990 to 2013				


Date Downloaded: November 8, 2013

Note: September and October 2013 are preliminary
*/



clear
insheet using "../../1raw/BLS-CES-healthemployment-nsa.csv"

drop if missing(v3)
ren v1 year
forvalues x = 1/12{
	ren v`=`x'+1' ces_emp_hcindr_nsa`x'
}
drop v14
drop in 1
destring, replace

reshape long ces_emp_hcindr_nsa, i(year) j(month)
gen mthyr = ym(year, month)
format mthyr %tm

label variable ces_emp_hcindr_nsa "Health Care Employment (CES, Thousands, Not Seasonally Ajusted)"
save `health_nsa', replace


clear
insheet using "../../1raw/BLS-CES-healthemployment-sa.csv"

drop if missing(v3)
ren v1 year
forvalues x = 1/12{
	ren v`=`x'+1' ces_emp_hcindr_sa`x'
}
drop v14
drop in 1
destring, replace

reshape long ces_emp_hcindr_sa, i(year) j(month)
gen mthyr = ym(year, month)
format mthyr %tm

label variable ces_emp_hcindr_sa "Health Care Employment (CES, Thousands, Not Seasonally Ajusted)"
save `health_sa', replace


clear 
insheet using "../../1raw/BLS-CES-totalemployment-nsa.csv"

drop if missing(v3)
ren v1 year
forvalues x = 1/12{
	ren v`=`x'+1' ces_emp_total_nsa`x'
}
drop v14
drop in 1
destring, replace

reshape long ces_emp_total_nsa, i(year) j(month)
gen mthyr = ym(year, month)
format mthyr %tm

label variable ces_emp_total_nsa "Total Nonfarm Employment (CES, Thousands, Not Seasonally Adjusted)"
save `total_nsa'




clear 
insheet using "../../1raw/BLS-CES-totalemployment-sa.csv"

drop if missing(v3)
ren v1 year
forvalues x = 1/12{
	ren v`=`x'+1' ces_emp_total_sa`x'
}
drop v14
drop in 1
destring, replace

reshape long ces_emp_total_sa, i(year) j(month)
gen mthyr = ym(year, month)
format mthyr %tm

label variable ces_emp_total_sa "Total Nonfarm Employment (CES, Thousands, Seasonally Adjusted)"

merge 1:1 mthyr using `total_nsa', nogen
merge 1:1 mthyr using `health_nsa', nogen
merge 1:1 mthyr using `health_sa', nogen
save "../../2data/BLS-CES-employment.dta", replace



