// Create expenditure tables from Altarum data
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: August 20, 2013



*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
version 11.2
clear
insheet using "../../1raw/altarum-NHEestimates.csv"


*********************************************************************
************************ RESHAPE DATA *******************************
*********************************************************************

//Levels (in $Billions)
ren v1 category

foreach var of varlist v2-v308{
	ren `var' ym`=lower(subinstr(`var'[1], " ", "_", .))'
}
drop in 1

destring, replace ignore(",")

gen varn =  "" 
replace varn = "totsp"			if lower(category) == lower("NHE")
replace varn = "gdp" 			if lower(category) == lower("GDP")


order varn category

local numvars = _N
forvalues x = 1/`numvars' {
	local cat`x' = category[`x']
	local varn`x' = varn[`x']
}
drop category

reshape long ym, i(varn) j(mthyr_str) string

rename ym sum

reshape wide sum, i(mthyr_str) j(varn) string

foreach var of varlist sum* {
	ren `var' `=substr("`var'", 4, .)'
}

gen mthyr = monthly(mthyr_str, "MY")
tsset mthyr, monthly
drop mthyr_str

gen year = year(dofm(mthyr))
order year mthyr

forvalues x = 1/`numvars' {
	label 	variable `varn`x'' "`cat`x''"
	char 	define `varn`x''[units] "Millions"
}

//keep only years that have data for every month
bys year: drop if _N != 12

//Average yearly expenditures
collapse (mean) totsp gdp, by(year)
foreach var of varlist  totsp gdp {
	replace `var' = `var' * 1000
	ren `var' altarum_`var'
}
`	


