

************************
*** prepare data set ***
************************

use data/state_level_data,clear

* change units
gen _interstate2005percap = interstate2005percap*10000

* create some variables
gen senate_dem_leader = 0
replace senate_dem_leader = 1 if inlist(stateabbrev,"ND" ,"HI" ,"CT" ,"CA" ,"NM" ,"MA" ,"MI" ,"NY")
replace senate_dem_leader = 1 if inlist(stateabbrev,"IA" ,"LA" ,"WV" ,"MT" ,"SD" ,"WI" ,"UT" ,"IL")

gen senate_repub_leader = 0
replace senate_repub_leader = 1 if inlist(stateabbrev,"KY" ,"AZ" ,"GA" ,"MS" ,"AL" ,"NH" ,"TX" ,"AK")
replace senate_repub_leader = 1 if inlist(stateabbrev,"OK" ,"IN" ,"WY" ,"ME" ,"PA" ,"NC" ,"OR" ,"MO")

gen is_senate_leader = senate_dem_leader==1 | senate_repub_leader==1

label var senate_dem_leader "Democratic leader"
label var senate_repub_leader "Republican leader"

*********************************
*** open file to write output ***
*********************************

cap file close myfile
file open myfile using output/tables/tmp.tex, write replace

file write myfile "\begin{tabular}{l c c c c c c } \toprule" _n
file write myfile "\multicolumn{1}{c}{Independent Variable:} 	& Senate Chair or & Average Senate  & Average Cong   & NE, PA 	  & NE, PA   \\ " _n
file write myfile "\multicolumn{1}{c}{} 						& Ranking Member  & Tenure          & Tenure 		  & ME		  & 		   \\ " _n
file write myfile "\midrule \noalign{\smallskip}" _n


*********************************************
*** Panel A. Agency-reported, no controls ***
*********************************************

file write myfile "\multicolumn{4}{l}{\textbf{\emph{Panel (a): Amount per resident -- Agency-reported}}} \\ \noalign{\smallskip}" _n

qui reg fundsawarded_pc fiscalChairRm, vce(robust)
local b1 : display %7.2f `=_b[fiscalChairRm]'
local s1 : display %7.2f `=_se[fiscalChairRm]'
local p1 = (2 * ttail(e(df_r), abs(_b[fiscalChairRm]/_se[fiscalChairRm]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg fundsawarded_pc state_emp_per_res, vce(robust)
local b2 : display %7.4f `=_b[state_emp_per_res]'
local s2 : display %7.4f `=_se[state_emp_per_res]'
local p2 = (2 * ttail(e(df_r), abs(_b[state_emp_per_res]/_se[state_emp_per_res]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg fundsawarded_pc avg_tenure_senate, vce(robust)
local b3 : display %7.3f `=_b[avg_tenure_senate]'
local s3 : display %7.3f `=_se[avg_tenure_senate]'
local p3 = (2 * ttail(e(df_r), abs(_b[avg_tenure_senate]/_se[avg_tenure_senate]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg fundsawarded_pc is_senate_leader, vce(robust)
local b4 : display %7.2f `=_b[is_senate_leader]'
local s4 : display %7.1f `=_se[is_senate_leader]'
local p4 = (2 * ttail(e(df_r), abs(_b[is_senate_leader]/_se[is_senate_leader]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg fundsawarded_pc avg_tenure_congress , vce(robust)
local b5 : display %7.2f `=_b[avg_tenure_congress]'
local s5 : display %7.3f `=_se[avg_tenure_congress]'
local p5 = (2 * ttail(e(df_r), abs(_b[avg_tenure_congress]/_se[avg_tenure_congress]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg fundsawarded_pc gang4, vce(robust)
local b6 : display %7.2f `=_b[gang4]'
local s6 : display %7.1f `=_se[gang4]'
local p6 = (2 * ttail(e(df_r), abs(_b[gang4]/_se[gang4]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg fundsawarded_pc specter_nelson, vce(robust)
local b7 : display %7.1f `=_b[specter_nelson]'
local s7 : display %7.1f `=_se[specter_nelson]'
local p7 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " No controls & `b4'`star4' & `b3'`star3' & `b5'`star5' & `b6'`star6' & `b7'`star7' \\" _n
file write myfile "  & (`s4') & (`s3') & (`s5') & (`s6') & (`s7') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r4' & `r3' & `r5' & `r6' & `r7' \\" _n
file write myfile " Observations 	& `n4' & `n3' & `n5' & `n6' & `n7' \\" _n
file write myfile "\noalign{\smallskip}" _n


***********************************************
*** Panel B. Agency-reported, with controls ***
***********************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{6}{l}{\textbf{\emph{Panel (b): Amount per resident -- Agency-reported}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg fundsawarded_pc fiscalChairRm  medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
local b1 : display %7.2f `=_b[fiscalChairRm]'
local s1 : display %7.2f `=_se[fiscalChairRm]'
local p1 = (2 * ttail(e(df_r), abs(_b[fiscalChairRm]/_se[fiscalChairRm]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg fundsawarded_pc state_emp_per_res medpercap2005 DemVoteShare _interstate2005percap  percent_poverty, vce(robust)
local b2 : display %7.4f `=_b[state_emp_per_res]'
local s2 : display %7.4f `=_se[state_emp_per_res]'
local p2 = (2 * ttail(e(df_r), abs(_b[state_emp_per_res]/_se[state_emp_per_res]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg fundsawarded_pc avg_tenure_senate percent_poverty medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res , vce(robust)
local b3 : display %7.3f `=_b[avg_tenure_senate]'
local s3 : display %7.3f `=_se[avg_tenure_senate]'
local p3 = (2 * ttail(e(df_r), abs(_b[avg_tenure_senate]/_se[avg_tenure_senate]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg fundsawarded_pc is_senate_leader medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b4 : display %7.2f `=_b[is_senate_leader]'
local s4 : display %7.2f `=_se[is_senate_leader]'
local p4 = (2 * ttail(e(df_r), abs(_b[is_senate_leader]/_se[is_senate_leader]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg fundsawarded_pc avg_tenure_congress medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b5 : display %7.3f `=_b[avg_tenure_congress]'
local s5 : display %7.3f `=_se[avg_tenure_congress]'
local p5 = (2 * ttail(e(df_r), abs(_b[avg_tenure_congress]/_se[avg_tenure_congress]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg fundsawarded_pc gang4 medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b6 : display %7.1f `=_b[gang4]'
local s6 : display %7.2f `=_se[gang4]'
local p6 = (2 * ttail(e(df_r), abs(_b[gang4]/_se[gang4]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg fundsawarded_pc specter_nelson medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b7 : display %7.1f `=_b[specter_nelson]'
local s7 : display %7.2f `=_se[specter_nelson]'
local p7 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " With controls & `b4'`star4' & `b3'`star3' & `b5'`star5' & `b6'`star6' & `b7'`star7' \\" _n
file write myfile "  & (`s4') & (`s3') & (`s5') & (`s6') & (`s7') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r4' & `r3' & `r5' & `r6' & `r7' \\" _n
file write myfile " Observations 	& `n4' & `n3' & `n5' & `n6' & `n7' \\" _n
file write myfile "\noalign{\smallskip}" _n


*************************************************************************
*** Panel C. Contracts grants and loans, with controls, with capitals ***
*************************************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{5}{l}{\textbf{\emph{Panel (c): Amount per resident -- Contracts, Grants, Loans}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg amtpc_Prime_popTotal_wcap fiscalChairRm  medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
local b1 : display %7.2f `=_b[fiscalChairRm]'
local s1 : display %7.2f `=_se[fiscalChairRm]'
local p1 = (2 * ttail(e(df_r), abs(_b[fiscalChairRm]/_se[fiscalChairRm]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap state_emp_per_res medpercap2005 DemVoteShare _interstate2005percap  percent_poverty, vce(robust)
local b2 : display %7.4f `=_b[state_emp_per_res]'
local s2 : display %7.4f `=_se[state_emp_per_res]'
local p2 = (2 * ttail(e(df_r), abs(_b[state_emp_per_res]/_se[state_emp_per_res]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap avg_tenure_senate percent_poverty medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res , vce(robust)
local b3 : display %7.3f `=_b[avg_tenure_senate]'
local s3 : display %7.3f `=_se[avg_tenure_senate]'
local p3 = (2 * ttail(e(df_r), abs(_b[avg_tenure_senate]/_se[avg_tenure_senate]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap is_senate_leader medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b4 : display %7.2f `=_b[is_senate_leader]'
local s4 : display %7.2f `=_se[is_senate_leader]'
local p4 = (2 * ttail(e(df_r), abs(_b[is_senate_leader]/_se[is_senate_leader]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap avg_tenure_congress medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b5 : display %7.3f `=_b[avg_tenure_congress]'
local s5 : display %7.3f `=_se[avg_tenure_congress]'
local p5 = (2 * ttail(e(df_r), abs(_b[avg_tenure_congress]/_se[avg_tenure_congress]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap gang4 medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b6 : display %7.2f `=_b[gang4]'
local s6 : display %7.1f `=_se[gang4]'
local p6 = (2 * ttail(e(df_r), abs(_b[gang4]/_se[gang4]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap specter_nelson medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b7 : display %7.1f `=_b[specter_nelson]'
local s7 : display %7.1f `=_se[specter_nelson]'
local p7 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " With controls & `b4'`star4' & `b3'`star3' & `b5'`star5' & `b6'`star6' & `b7'`star7' \\" _n
file write myfile "  & (`s4') & (`s3') & (`s5') & (`s6') & (`s7') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r4' & `r3' & `r5' & `r6' & `r7' \\" _n
file write myfile " Observations 	& `n4' & `n3' & `n5' & `n6' & `n7' \\" _n
file write myfile "\noalign{\smallskip}" _n


***********************************************************************
*** Panel D. Contracts grants and loans, with controls, no capitals ***
***********************************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{5}{l}{\textbf{\emph{Panel (d): Amount per resident -- Contracts, Grants, Loans}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg amtpc_Prime_popTotal_nocap fiscalChairRm  medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
local b1 : display %7.2f `=_b[fiscalChairRm]'
local s1 : display %7.2f `=_se[fiscalChairRm]'
local p1 = (2 * ttail(e(df_r), abs(_b[fiscalChairRm]/_se[fiscalChairRm]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap state_emp_per_res medpercap2005 DemVoteShare _interstate2005percap  percent_poverty, vce(robust)
local b2 : display %7.4f `=_b[state_emp_per_res]'
local s2 : display %7.4f `=_se[state_emp_per_res]'
local p2 = (2 * ttail(e(df_r), abs(_b[state_emp_per_res]/_se[state_emp_per_res]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap avg_tenure_senate percent_poverty medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res , vce(robust)
local b3 : display %7.3f `=_b[avg_tenure_senate]'
local s3 : display %7.3f `=_se[avg_tenure_senate]'
local p3 = (2 * ttail(e(df_r), abs(_b[avg_tenure_senate]/_se[avg_tenure_senate]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap is_senate_leader medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b4 : display %7.1f `=_b[is_senate_leader]'
local s4 : display %7.2f `=_se[is_senate_leader]'
local p4 = (2 * ttail(e(df_r), abs(_b[is_senate_leader]/_se[is_senate_leader]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap avg_tenure_congress medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b5 : display %7.3f `=_b[avg_tenure_congress]'
local s5 : display %7.3f `=_se[avg_tenure_congress]'
local p5 = (2 * ttail(e(df_r), abs(_b[avg_tenure_congress]/_se[avg_tenure_congress]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap gang4 medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b6 : display %7.2f `=_b[gang4]'
local s6 : display %7.2f `=_se[gang4]'
local p6 = (2 * ttail(e(df_r), abs(_b[gang4]/_se[gang4]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap specter_nelson medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b7 : display %7.2f `=_b[specter_nelson]'
local s7 : display %7.2f `=_se[specter_nelson]'
local p7 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " With controls & `b4'`star4' & `b3'`star3' & `b5'`star5' & `b6'`star6' & `b7'`star7' \\" _n
file write myfile "  & (`s4') & (`s3') & (`s5') & (`s6') & (`s7') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r4' & `r3' & `r5' & `r6' & `r7' \\" _n
file write myfile " Observations 	& `n4' & `n3' & `n5' & `n6' & `n7' \\" _n
file write myfile "\noalign{\smallskip}" _n



********************************
*** end table and close file ***
********************************

file write myfile "\bottomrule \end{tabular}" _n

cap file close myfile



*********************************************
*** delete extra spaces after parentheses ***
*********************************************

filefilter output/tables/tmp.tex output/tables/tmp1.tex, from("( ") to("(") replace
filefilter output/tables/tmp1.tex output/tables/tmp2.tex, from("( ") to("(") replace
filefilter output/tables/tmp2.tex output/tables/Table9.tex, from("( ") to("(") replace

erase output/tables/tmp.tex
erase output/tables/tmp1.tex
erase output/tables/tmp2.tex



