


* code to get p-val comes from: 
* http://www.stata.com/statalist/archive/2006-11/msg00892.html
* http://www.maartenbuis.nl/publications/p-value.pdf


************************
*** prepare data set ***
************************

use data/district_level_data, clear

* drop state capitals
drop if iscap==1

* absolute value of DW-Nominate
gen absdw1 = abs(dw1)

* dummy variables for Specter and Nelson
gen specter = stateabbrev=="PA"
gen nelson = stateabbrev=="NE"
gen specter_nelson = inlist(stateabbrev,"PA","NE")

** get arra votes, including not voting
gen arrayes = vote=="Yea"
* the following districts abstained from ARRA votes: 0648, 3626, 4506 (capital district)
gen arraVote = arrayes
replace arraVote = 2 if district=="0648" | district=="3626" | district=="4506"
* the following districts didn't have any representatives, so there was no vote
replace arraVote = . if district=="1705" | district=="3620"
* voting against party
gen arraVoteAgainstParty = 0
replace arraVoteAgainstParty = . if district=="1705" | district=="3620"
replace arraVoteAgainstParty = 1 if dem==1 & inlist(arraVote,0)
replace arraVoteAgainstParty = 1 if dem==0 & inlist(arraVote,1)
gen againstParty = arraVoteAgainstParty
gen demAgainst = arraVoteAgainstParty==1 & dem==1
gen repAgainst = arraVoteAgainstParty==1 & dem==0
* voting against party or abstaining
gen arraVoteAgainst_inclAbstain = 0
replace arraVoteAgainst_inclAbstain = . if district=="1705" | district=="3620"
replace arraVoteAgainst_inclAbstain = 1 if dem==1 & inlist(arraVote,0,2)
replace arraVoteAgainst_inclAbstain = 1 if dem==0 & inlist(arraVote,1,2)
gen againstParty_abst = arraVoteAgainst_inclAbstain
gen demAgainst_abst = arraVoteAgainst_inclAbstain==1 & dem==1
replace demAgainst_abst = . if arraVoteAgainst_inclAbstain==. | dem==.
gen repAgainst_abst = arraVoteAgainst_inclAbstain==1 & dem==0
replace repAgainst_abst = . if arraVoteAgainst_inclAbstain==. | dem==.

* label some vars
label var againstParty      "vote against party"
label var demAgainst        "D vote NO or PRESENT"
label var repAgainst        "R vote YES"
label var againstParty_abst "Vote against party or abstain"
label var demAgainst_abst   "Democrat: NO / PRESENT / abstain"
label var repAgainst_abst   "Republican: YES or abstain"
label var dist_emp_th "Employment (thousands)"

* create vote share group dummies
gen v5dum1  = demVoteSh_house==0
gen v5dum2  = demVoteSh_house>0 & demVoteSh_house<30
gen v5dum3  = demVoteSh_house>=30 & demVoteSh_house<40
gen v5dum4  = demVoteSh_house>=40 & demVoteSh_house<50
gen v5dum5  = demVoteSh_house>=50 & demVoteSh_house<60
gen v5dum6  = demVoteSh_house>=60 & demVoteSh_house<70
gen v5dum7  = demVoteSh_house>=70 & demVoteSh_house<80
gen v5dum8  = demVoteSh_house>=80 & demVoteSh_house<90
gen v5dum9  = demVoteSh_house>=90 & demVoteSh_house<100
gen v5dum10  = demVoteSh_house==100
label var v5dum1 "Unopposed Repub (13)"
label var v5dum2 "Dem vote share 1-30 (16) "
label var v5dum3 "Dem vote share 30-40 (63)"
label var v5dum4 "Dem vote share 40-50 (46)"
label var v5dum5 "Dem vote share 50-60 (42)"
label var v5dum6 "Dem vote share 60-70 (44)"
label var v5dum7 "Dem vote share 70-80 (51)"
label var v5dum8 "Dem vote share 80-90 (20)"
label var v5dum9 "Dem vote share 90-99 (5)"
label var v5dum10 "Unopposed Dem (34)"



*********************************
*** open file to write output ***
*********************************

cap file close myfile
file open myfile using output/tables/tmp.tex, write replace

file write myfile "\begin{tabular}{l c c c c c } \toprule" _n
file write myfile "\multicolumn{1}{c}{Independent Variable:} & DW-Nominate 	& abs(DW-N) 		& PA, NE	& Vote Against 		& Democrats 	\\ " _n
file write myfile "\multicolumn{1}{c}{} 					 & 				& 					& 			& Party or Abstain	& voting against 		\\ " _n
file write myfile "\midrule \noalign{\smallskip}" _n


*************************************************
*** Panel A. Amount per resident, no controls ***
*************************************************

file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (a): Amount per resident}}} \\ \noalign{\smallskip}" _n

qui reg amtpc dw1, cluster(statefips)
local b1 : display %7.1f `=_b[dw1]'
local s1 : display %7.2f `=_se[dw1]'
local p1 = (2 * ttail(e(df_r), abs(_b[dw1]/_se[dw1]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc absdw1, cluster(statefips)
local b2 : display %7.1f `=_b[absdw1]'
local s2 : display %7.1f `=_se[absdw1]'
local p2 = (2 * ttail(e(df_r), abs(_b[absdw1]/_se[absdw1]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc demGov, cluster(statefips)
local b3 : display %7.2f `=_b[demGov]'
local s3 : display %7.2f `=_se[demGov]'
local p3 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc specter_nelson, cluster(statefips)
local b4 : display %7.3f `=_b[specter_nelson]'
local s4 : display %7.2f `=_se[specter_nelson]'
local p4 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc againstParty_abst, cluster(statefips)
local b5 : display %7.2f `=_b[againstParty_abst]'
local s5 : display %7.2f `=_se[againstParty_abst]'
local p5 = (2 * ttail(e(df_r), abs(_b[againstParty_abst]/_se[againstParty_abst]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc demAgainst, cluster(statefips)
local b6 : display %7.2f `=_b[demAgainst]'
local s6 : display %7.2f `=_se[demAgainst]'
local p6 = (2 * ttail(e(df_r), abs(_b[demAgainst]/_se[demAgainst]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'

forvalues i = 1/6 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " No controls & `b1'`star1' & `b2'`star2' & `b4'`star4' & `b5'`star5' & `b6'`star6' \\" _n
file write myfile "  & (`s1') & (`s2') & (`s4') & (`s5') & (`s6') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r4' & `r5' & `r6' \\" _n
file write myfile "\\" _n


****************************************************************
*** Panel B. Amount per resident, all controls but land area ***
****************************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (b): Amount per resident}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

local covars3 percentPoverty pcturban totalmiles

qui reg amtpc dw1 v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b1 : display %7.1f `=_b[dw1]'
local s1 : display %7.1f `=_se[dw1]'
local p1 = (2 * ttail(e(df_r), abs(_b[dw1]/_se[dw1]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc absdw1 v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b2 : display %7.3f `=_b[absdw1]'
local s2 : display %7.1f `=_se[absdw1]'
local p2 = (2 * ttail(e(df_r), abs(_b[absdw1]/_se[absdw1]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc demGov v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b3 : display %7.2f `=_b[demGov]'
local s3 : display %7.2f `=_se[demGov]'
local p3 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc specter_nelson v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b4 : display %7.2f `=_b[specter_nelson]'
local s4 : display %7.2f `=_se[specter_nelson]'
local p4 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc againstParty_abst v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b5 : display %7.2f `=_b[againstParty_abst]'
local s5 : display %7.2f `=_se[againstParty_abst]'
local p5 = (2 * ttail(e(df_r), abs(_b[againstParty_abst]/_se[againstParty_abst]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc demAgainst v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b6 : display %7.2f `=_b[demAgainst]'
local s6 : display %7.2f `=_se[demAgainst]'
local p6 = (2 * ttail(e(df_r), abs(_b[demAgainst]/_se[demAgainst]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'

forvalues i = 1/6 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " All controls except  	& `b1'`star1' & `b2'`star2' & `b4'`star4' & `b5'`star5' & `b6'`star6' \\" _n
file write myfile " land area				& (`s1') & (`s2') & (`s4') & (`s5') & (`s6') \\" _n
file write myfile "\\" _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r4' & `r5' & `r6' \\" _n
file write myfile "\\" _n



**************************************************
*** Panel C. Amount per resident, all controls ***
**************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (c): Amount per resident}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

local covars1 percentPoverty pcturban larea totalmiles

qui reg amtpc dw1 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b1 : display %7.1f `=_b[dw1]'
local s1 : display %7.1f `=_se[dw1]'
local p1 = (2 * ttail(e(df_r), abs(_b[dw1]/_se[dw1]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc absdw1 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b2 : display %7.2f `=_b[absdw1]'
local s2 : display %7.1f `=_se[absdw1]'
local p2 = (2 * ttail(e(df_r), abs(_b[absdw1]/_se[absdw1]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc demGov v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b3 : display %7.2f `=_b[demGov]'
local s3 : display %7.2f `=_se[demGov]'
local p3 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc specter_nelson v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b4 : display %7.2f `=_b[specter_nelson]'
local s4 : display %7.2f `=_se[specter_nelson]'
local p4 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc againstParty_abst v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b5 : display %7.1f `=_b[againstParty_abst]'
local s5 : display %7.2f `=_se[againstParty_abst]'
local p5 = (2 * ttail(e(df_r), abs(_b[againstParty_abst]/_se[againstParty_abst]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc demAgainst v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b6 : display %7.1f `=_b[demAgainst]'
local s6 : display %7.2f `=_se[demAgainst]'
local p6 = (2 * ttail(e(df_r), abs(_b[demAgainst]/_se[demAgainst]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'

forvalues i = 1/6 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " All controls & `b1'`star1' & `b2'`star2' & `b4'`star4' & `b5'`star5' & `b6'`star6' \\" _n
file write myfile " 			 & (`s1') & (`s2') & (`s4') & (`s5') & (`s6') \\" _n
file write myfile "\\" _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r4' & `r5' & `r6' \\" _n
file write myfile "\\" _n



***********************************************
*** Panel D. Amount per worker, no controls ***
***********************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (d): Amount per worker}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg amtpw dw1, cluster(statefips)
local b1 : display %7.2f `=_b[dw1]'
local s1 : display %7.1f `=_se[dw1]'
local p1 = (2 * ttail(e(df_r), abs(_b[dw1]/_se[dw1]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpw absdw1, cluster(statefips)
local b2 : display %7.1f `=_b[absdw1]'
local s2 : display %7.1f `=_se[absdw1]'
local p2 = (2 * ttail(e(df_r), abs(_b[absdw1]/_se[absdw1]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpw demGov, cluster(statefips)
local b3 : display %7.2f `=_b[demGov]'
local s3 : display %7.1f `=_se[demGov]'
local p3 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpw specter_nelson, cluster(statefips)
local b4 : display %7.2f `=_b[specter_nelson]'
local s4 : display %7.2f `=_se[specter_nelson]'
local p4 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpw againstParty_abst, cluster(statefips)
local b5 : display %7.1f `=_b[againstParty_abst]'
local s5 : display %7.1f `=_se[againstParty_abst]'
local p5 = (2 * ttail(e(df_r), abs(_b[againstParty_abst]/_se[againstParty_abst]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpw demAgainst, cluster(statefips)
local b6 : display %7.1f `=_b[demAgainst]'
local s6 : display %7.1f `=_se[demAgainst]'
local p6 = (2 * ttail(e(df_r), abs(_b[demAgainst]/_se[demAgainst]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'

forvalues i = 1/6 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " No controls & `b1'`star1' & `b2'`star2' & `b4'`star4' & `b5'`star5' & `b6'`star6' \\" _n
file write myfile "  & (`s1') & (`s2') & (`s4') & (`s5') & (`s6') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r4' & `r5' & `r6' \\" _n
file write myfile "\\" _n



************************************************
*** Panel E. Amount per worker, all controls ***
************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (e): Amount per worker}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

local covars1 percentPoverty pcturban larea totalmiles

qui reg amtpw dw1 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b1 : display %7.2f `=_b[dw1]'
local s1 : display %7.1f `=_se[dw1]'
local p1 = (2 * ttail(e(df_r), abs(_b[dw1]/_se[dw1]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpw absdw1 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b2 : display %7.1f `=_b[absdw1]'
local s2 : display %7.1f `=_se[absdw1]'
local p2 = (2 * ttail(e(df_r), abs(_b[absdw1]/_se[absdw1]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpw demGov v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b3 : display %7.1f `=_b[demGov]'
local s3 : display %7.1f `=_se[demGov]'
local p3 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpw specter_nelson v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b4 : display %7.2f `=_b[specter_nelson]'
local s4 : display %7.1f `=_se[specter_nelson]'
local p4 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpw againstParty_abst v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b5 : display %7.1f `=_b[againstParty_abst]'
local s5 : display %7.1f `=_se[againstParty_abst]'
local p5 = (2 * ttail(e(df_r), abs(_b[againstParty_abst]/_se[againstParty_abst]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpw demAgainst v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b6 : display %7.1f `=_b[demAgainst]'
local s6 : display %7.1f `=_se[demAgainst]'
local p6 = (2 * ttail(e(df_r), abs(_b[demAgainst]/_se[demAgainst]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'

forvalues i = 1/6 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " All controls & `b1'`star1' & `b2'`star2' & `b4'`star4' & `b5'`star5' & `b6'`star6' \\" _n
file write myfile " 			 & (`s1') & (`s2') & (`s4') & (`s5') & (`s6') \\" _n
file write myfile "\\" _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r4' & `r5' & `r6' \\" _n
file write myfile "\\" _n



********************************
*** end table and close file ***
********************************

file write myfile " Observations 	& `n1' & `n2' & `n4' & `n5' & `n6' \\" _n
file write myfile "\\" _n

file write myfile "\bottomrule \end{tabular}" _n

cap file close myfile


*********************************************
*** delete extra spaces after parentheses ***
*********************************************

filefilter output/tables/tmp.tex output/tables/tmp1.tex, from("( ") to("(") replace
filefilter output/tables/tmp1.tex output/tables/tmp2.tex, from("( ") to("(") replace
filefilter output/tables/tmp2.tex output/tables/Table8.tex, from("( ") to("(") replace

erase output/tables/tmp.tex
erase output/tables/tmp1.tex
erase output/tables/tmp2.tex
