

************************
*** prepare data set ***
************************

use data/state_level_data,clear

* change units
gen _interstate2005percap = interstate2005percap*10000

tab numDemsIndSen, gen(numDemsIndSen_)
rename numDemsIndSen_1 numDemsIndSen_0
rename numDemsIndSen_2 numDemsIndSen_1
rename numDemsIndSen_3 numDemsIndSen_2

*********************************
*** open file to write output ***
*********************************


cap file close myfile
file open myfile using output/tables/tmp.tex, write replace

file write myfile "\begin{tabular}{l c c c c } \toprule" _n
file write myfile "\multicolumn{1}{c}{Independent Variable:} 	 & Democratic 	& Obama     & \# Dem    & Senate Dem   \\ " _n
file write myfile "\multicolumn{1}{c}{} 						 & Governor	    & 50-52\%   & Senators  & Vote Share   \\ " _n
file write myfile "\midrule \noalign{\smallskip}" _n


*********************************************
*** Panel A. Agency-reported, no controls ***
*********************************************

file write myfile "\multicolumn{4}{l}{\textbf{\emph{Panel (a): Amount per resident -- Agency-reported}}} \\ \noalign{\smallskip}" _n

qui reg fundsawarded_pc numDemsIndSen, vce(robust)
local b1 : display %7.1f `=_b[numDemsIndSen]'
local s1 : display %7.2f `=_se[numDemsIndSen]'
local p1 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen]/_se[numDemsIndSen]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg fundsawarded_pc DemVoteShare, vce(robust)
local b2 : display %7.2f `=_b[DemVoteShare]'
local s2 : display %7.3f `=_se[DemVoteShare]'
local p2 = (2 * ttail(e(df_r), abs(_b[DemVoteShare]/_se[DemVoteShare]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg fundsawarded_pc percent_poverty, vce(robust)
local b3 : display %7.2f `=_b[percent_poverty]'
local s3 : display %7.2f `=_se[percent_poverty]'
local p3 = (2 * ttail(e(df_r), abs(_b[percent_poverty]/_se[percent_poverty]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg fundsawarded_pc demGov, vce(robust)
local b4 : display %7.2f `=_b[demGov]'
local s4 : display %7.1f `=_se[demGov]'
local p4 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg fundsawarded_pc closeObama , vce(robust)
local b5 : display %7.1f `=_b[closeObama]'
local s5 : display %7.2f `=_se[closeObama]'
local p5 = (2 * ttail(e(df_r), abs(_b[closeObama]/_se[closeObama]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg fundsawarded_pc numDemsIndSen_1 numDemsIndSen_2, vce(robust)
local b6 : display %7.2f `=_b[numDemsIndSen_1]'
local s6 : display %7.1f `=_se[numDemsIndSen_1]'
local p6 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen_1]/_se[numDemsIndSen_1]))) 
local b7 : display %7.2f `=_b[numDemsIndSen_2]'
local s7 : display %7.1f `=_se[numDemsIndSen_2]'
local p7 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen_2]/_se[numDemsIndSen_2]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " No controls & `b4'`star4' & `b5'`star5' & `b1'`star1' & `b2'`star2' \\" _n
file write myfile "  & (`s4') & (`s5') & (`s1') & (`s2') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r4' & `r5' & `r1' & `r2' \\" _n
file write myfile " Observations 	& `n4' & `n5' & `n1' & `n2' \\" _n
file write myfile "\noalign{\smallskip}" _n



***********************************************
*** Panel B. Agency-reported, with controls ***
***********************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{4}{l}{\textbf{\emph{Panel (b): Amount per resident -- Agency-reported}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg fundsawarded_pc numDemsIndSen  medpercap2005 _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
local b1 : display %7.1f `=_b[numDemsIndSen]'
local s1 : display %7.2f `=_se[numDemsIndSen]'
local p1 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen]/_se[numDemsIndSen]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg fundsawarded_pc DemVoteShare state_emp_per_res medpercap2005 _interstate2005percap  percent_poverty, vce(robust)
local b2 : display %7.3f `=_b[DemVoteShare]'
local s2 : display %7.3f `=_se[DemVoteShare]'
local p2 = (2 * ttail(e(df_r), abs(_b[DemVoteShare]/_se[DemVoteShare]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg fundsawarded_pc percent_poverty medpercap2005 _interstate2005percap state_emp_per_res , vce(robust)
local b3 : display %7.2f `=_b[percent_poverty]'
local s3 : display %7.2f `=_se[percent_poverty]'
local p3 = (2 * ttail(e(df_r), abs(_b[percent_poverty]/_se[percent_poverty]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg fundsawarded_pc demGov medpercap2005 _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b4 : display %7.2f `=_b[demGov]'
local s4 : display %7.1f `=_se[demGov]'
local p4 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg fundsawarded_pc closeObama medpercap2005 _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b5 : display %7.1f `=_b[closeObama]'
local s5 : display %7.2f `=_se[closeObama]'
local p5 = (2 * ttail(e(df_r), abs(_b[closeObama]/_se[closeObama]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg fundsawarded_pc numDemsIndSen_1 numDemsIndSen_2 medpercap2005 _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b6 : display %7.1f `=_b[numDemsIndSen_1]'
local s6 : display %7.1f `=_se[numDemsIndSen_1]'
local p6 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen_1]/_se[numDemsIndSen_1]))) 
local b7 : display %7.1f `=_b[numDemsIndSen_2]'
local s7 : display %7.1f `=_se[numDemsIndSen_2]'
local p7 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen_2]/_se[numDemsIndSen_2]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " With controls & `b4'`star4' & `b5'`star5' & `b1'`star1' & `b2'`star2' \\" _n
file write myfile "  & (`s4') & (`s5') & (`s1') & (`s2') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r4' & `r5' & `r1' & `r2' \\" _n
file write myfile " Observations 	& `n4' & `n5' & `n1' & `n2' \\" _n
file write myfile "\noalign{\smallskip}" _n



*************************************************************************
*** Panel C. Contracts grants and loans, with controls, with capitals ***
*************************************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{5}{l}{\textbf{\emph{Panel (c): Amount per resident -- Contracts, Grants, Loans}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg amtpc_Prime_popTotal_wcap numDemsIndSen  medpercap2005 _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
local b1 : display %7.2f `=_b[numDemsIndSen]'
local s1 : display %7.2f `=_se[numDemsIndSen]'
local p1 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen]/_se[numDemsIndSen]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap DemVoteShare state_emp_per_res medpercap2005 _interstate2005percap  percent_poverty, vce(robust)
local b2 : display %7.3f `=_b[DemVoteShare]'
local s2 : display %7.3f `=_se[DemVoteShare]'
local p2 = (2 * ttail(e(df_r), abs(_b[DemVoteShare]/_se[DemVoteShare]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap percent_poverty medpercap2005 _interstate2005percap state_emp_per_res , vce(robust)
local b3 : display %7.2f `=_b[percent_poverty]'
local s3 : display %7.2f `=_se[percent_poverty]'
local p3 = (2 * ttail(e(df_r), abs(_b[percent_poverty]/_se[percent_poverty]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap demGov medpercap2005 _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b4 : display %7.1f `=_b[demGov]'
local s4 : display %7.2f `=_se[demGov]'
local p4 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap closeObama medpercap2005 _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b5 : display %7.1f `=_b[closeObama]'
local s5 : display %7.2f `=_se[closeObama]'
local p5 = (2 * ttail(e(df_r), abs(_b[closeObama]/_se[closeObama]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap numDemsIndSen_1 numDemsIndSen_2 medpercap2005 _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b6 : display %7.1f `=_b[numDemsIndSen_1]'
local s6 : display %7.2f `=_se[numDemsIndSen_1]'
local p6 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen_1]/_se[numDemsIndSen_1]))) 
local b7 : display %7.1f `=_b[numDemsIndSen_2]'
local s7 : display %7.2f `=_se[numDemsIndSen_2]'
local p7 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen_2]/_se[numDemsIndSen_2]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " With controls & `b4'`star4' & `b5'`star5' & `b1'`star1' & `b2'`star2' \\" _n
file write myfile "  & (`s4') & (`s5') & (`s1') & (`s2') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r4' & `r5' & `r1' & `r2' \\" _n
file write myfile " Observations 	& `n4' & `n5' & `n1' & `n2' \\" _n
file write myfile "\noalign{\smallskip}" _n



***********************************************************************
*** Panel D. Contracts grants and loans, with controls, no capitals ***
***********************************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{5}{l}{\textbf{\emph{Panel (d): Amount per resident -- Contracts, Grants, Loans}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg amtpc_Prime_popTotal_nocap numDemsIndSen  medpercap2005 _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
local b1 : display %7.3f `=_b[numDemsIndSen]'
local s1 : display %7.2f `=_se[numDemsIndSen]'
local p1 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen]/_se[numDemsIndSen]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap DemVoteShare state_emp_per_res medpercap2005 _interstate2005percap  percent_poverty, vce(robust)
local b2 : display %7.3f `=_b[DemVoteShare]'
local s2 : display %7.3f `=_se[DemVoteShare]'
local p2 = (2 * ttail(e(df_r), abs(_b[DemVoteShare]/_se[DemVoteShare]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap percent_poverty medpercap2005 _interstate2005percap state_emp_per_res , vce(robust)
local b3 : display %7.2f `=_b[percent_poverty]'
local s3 : display %7.2f `=_se[percent_poverty]'
local p3 = (2 * ttail(e(df_r), abs(_b[percent_poverty]/_se[percent_poverty]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap demGov medpercap2005 _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b4 : display %7.2f `=_b[demGov]'
local s4 : display %7.2f `=_se[demGov]'
local p4 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap closeObama medpercap2005 _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b5 : display %7.1f `=_b[closeObama]'
local s5 : display %7.2f `=_se[closeObama]'
local p5 = (2 * ttail(e(df_r), abs(_b[closeObama]/_se[closeObama]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap numDemsIndSen_1 numDemsIndSen_2 medpercap2005 _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b6 : display %7.1f `=_b[numDemsIndSen_1]'
local s6 : display %7.2f `=_se[numDemsIndSen_1]'
local p6 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen_1]/_se[numDemsIndSen_1]))) 
local b7 : display %7.1f `=_b[numDemsIndSen_2]'
local s7 : display %7.2f `=_se[numDemsIndSen_2]'
local p7 = (2 * ttail(e(df_r), abs(_b[numDemsIndSen_2]/_se[numDemsIndSen_2]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " With controls & `b4'`star4' & `b5'`star5' & `b1'`star1' & `b2'`star2' \\" _n
file write myfile " (no capitals) & (`s4') & (`s5') & (`s1') & (`s2') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r4' & `r5' & `r1' & `r2' \\" _n
file write myfile " Observations 	& `n4' & `n5' & `n1' & `n2' \\" _n
file write myfile "\noalign{\smallskip}" _n





********************************
*** end table and close file ***
********************************

file write myfile "\bottomrule \end{tabular}" _n

cap file close myfile


*********************************************
*** delete extra spaces after parentheses ***
*********************************************

filefilter output/tables/tmp.tex output/tables/tmp1.tex, from("( ") to("(") replace
filefilter output/tables/tmp1.tex output/tables/tmp2.tex, from("( ") to("(") replace
filefilter output/tables/tmp2.tex output/tables/Table6.tex, from("( ") to("(") replace

erase output/tables/tmp.tex
erase output/tables/tmp1.tex
erase output/tables/tmp2.tex
