

************************
*** prepare data set ***
************************

use data/district_level_data, clear

* label vars
label var dem "Democratic Representative"
label var percentPoverty "Percent Poverty"
label var pcturban "Percent Urban"
label var larea "Land Area"
label var totalmiles "Total Highway miles"
label var dist_emp_th "Employment (thousands)"

***********************
*** run regressions ***
***********************

estimates clear

qui eststo: reg amtpc dem, cluster(statefips)
qui estadd local capitals = "X"

* now drop capitals
drop if iscap==1

qui eststo: reg amtpc dem         , cluster(statefips)
qui eststo: reg amtpc dem dist_emp_th, cluster(statefips)
qui eststo: reg amtpc dem dist_emp_th percentPoverty, cluster(statefips)
qui eststo: reg amtpc dem dist_emp_th larea totalmiles pcturban , cluster(statefips)
qui eststo: reg amtpc dem dist_emp_th percentPoverty larea totalmiles pcturban , cluster(statefips)
qui eststo: reg amtpw dem , cluster(statefips)
qui eststo: reg amtpw dem percentPoverty larea totalmiles pcturban , cluster(statefips)


******************
*** save table ***
******************

esttab * using output/tables/Table4.tex, replace se r2 label booktabs star(* 0.10 ** 0.05 *** 0.01) ///
mgroups("Per Resident" "Per Worker", pattern(1 0 0 0 0 0 1 0) ///
prefix(\multicolumn{@span}{c}{) suffix(})   ///
span erepeat(\cmidrule(lr){@span}))         ///
scalar("capitals Includes state capitals") ///
nonotes nomtitles


