
cap program drop lpolyci
program define lpolyci, eclass
version 11
syntax varlist [if] [in] [aweight] , BWidth(passthru) GENerate(string)  [Kernel(passthru) DEGree(passthru) n(passthru)   Reps(integer 100) Band(real 1.96) Cluster(varname)]
 
 	tokenize `generate'
 	local newvarx = "`1'"
 	local newvars = "`2'"
 
 	marksample touse
	tokenize `varlist'
	local y = "`1'" 
	local x ="`2'"
 
 	tempfile datatemp
 	
 	cap drop  `newvarx' 
 	cap drop `newvars'
 	cap drop `newvars'_*
 	
 	 
	qui lpoly `y' `x' if `touse' [`weight' `exp'],  gen(`newvarx'  `newvars') `bwidth' `kernel' `degree' `n'   nograph `noscatter'
	preserve
	keep  `newvarx'  `newvars'
	drop if `newvarx'==.
	duplicates drop `newvarx', force
 	qui save "`datatemp'", replace
	restore
 
 	local i=1
	while `i' <=`reps' {
		di `i'
		preserve
 
		if "`cluster'" =="" {
				bsample
		}
		else{
				bsample, cluster(`cluster')
		}		
		cap drop `newvarx'
		qui  lpoly `y' `x' if `touse',  gen(`newvarx'  `newvars'_`i') `bwidth' `kernel' `degree' `n'   nograph  `noscatter'
		qui drop if `newvarx'==.
		qui duplicates drop `newvarx', force
		keep `newvarx' `newvars'_`i'	
		qui merge 1:1 `newvarx' using "`datatemp'", nogen
		qui save "`datatemp'", replace
 
		restore
		local i=`i'+1
	}
  
 
preserve

use "`datatemp'", clear
sum

cap drop _sd
qui egen _sd=rowsd(`newvars'_*)
 
gen `newvars'_min=`newvars' - _sd*`band' 
gen `newvars'_max=`newvars' + _sd*`band' 
qui duplicates drop `newvarx', force

keep `newvars'  `newvars'_min `newvars'_max  `newvarx'
qui save "`datatemp'", replace
restore

qui merge m:1 `newvarx' using "`datatemp'", nogen
 
twoway  line `newvars'  `newvars'_min `newvars'_max `newvarx', sort lpat("l" "-" "-") lcolor(black black black)
 
end

