


use data/district_level_data,clear

* drop state capitals
drop if iscap==1

* get list of control variables
local covars dist_emp percentPoverty pcturban larea totalmiles


* get lpoly lpoly bandwidth
* 1.65
*lpoly amtpc nterms_house
* 2.36
*lpoly amtpc nterms_house if dem==0
* 1.92
*lpoly amtpc nterms_house if dem==1

* get average of D and R bandwidths, to use same one for each
*display "`=(1.92+2.36)/2'" 
* = 2.14

* Semi-parametric regressions: amount per capita vs number of terms, with controls.

* Panel a. Non-parametric
twoway lpolyci amtpc nterms_house, ciplot(rline) alp(dash) acolor(black) clc(black) legend(off) ///
xtitle("") ytitle("") graphregion(fcolor(white) lcolor(white)) subtitle("(a) Non-parametric", pos(11)) ylabel(,nogrid)
graph save output/figures/g1.gph, replace

* Panel b. Semi-parametric
preserve
plreglpci amtpc `covars',  nlf(nterms_house) gen(mygrid ehat) bw(1.65) 
sort mygrid
scatter ehat_min ehat ehat_max mygrid, subtitle("(b) Semi-parametric", pos(11)) xtitle("") ms(i i i) c(l l l) lp(- l -) lc(black black black) legend(off) graphregion(fcolor(white) lcolor(white)) ylabel(,nogrid)
graph save output/figures/g2.gph, replace
restore

* Panel c. Semi-parametric - republicans only
preserve
keep if dem==0
plreglpci amtpc `covars',  nlf(nterms_house) gen(mygrid ehat) bw(2.14) 
sort mygrid
scatter ehat_min ehat ehat_max mygrid, subtitle("(c) Semi-parametric: Republicans only", pos(11)) xtitle("Number of terms") ms(i i i) c(l l l) lp(- l -) lc(black black black) legend(off) graphregion(fcolor(white) lcolor(white)) ylabel(,nogrid)
graph save output/figures/g3.gph, replace
restore

* Panel d. Semi-parametric - democrats only
preserve
keep if dem==1
plreglpci amtpc `covars',  nlf(nterms_house) gen(mygrid ehat) bw(2.14) 
sort mygrid
scatter ehat_min ehat ehat_max mygrid, subtitle("(d) Semi-parametric: Democrats only", pos(11)) xtitle("Number of terms") ms(i i i) c(l l l) lp(- l -) lc(black black black) legend(off) graphregion(fcolor(white) lcolor(white)) ylabel(,nogrid)
graph save output/figures/g4.gph, replace
restore


* combine and export
graph combine output/figures/g1.gph output/figures/g2.gph output/figures/g3.gph output/figures/g4.gph , ///
	ycommon xcommon l1title("stimulus amount per resident ($)") graphregion(fcolor(white) lcolor(white)) 
graph export output/figures/FigureA7.$figureFormat, replace

* clean up
erase output/figures/g1.gph 
erase output/figures/g2.gph
erase output/figures/g3.gph
erase output/figures/g4.gph



