

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

* get list of control variables
local covars percentPoverty pcturban larea totalmiles

* panel a. non-parametric regression
twoway lpolyci amtpw demVoteSh_house, ciplot(rline) alp(dash) acolor(black) clc(black) legend(off) ///
	xtitle("Democratic vote share (%)") ytitle("") xline(50, lpattern(.)) graphregion(fcolor(white) lcolor(white)) ///
	subtitle("(a) Non-parametric", pos(11)) ylabel(,nogrid)
graph save output/figures/amountVsVoteShare_nonParametric.gph, replace

* panel b.  semi-parametric regression using plreglpci 
preserve
plreglpci amtpw `covars' ,  nlf(demVoteSh_house) gen(mygrid ehat) bw(4.25) 
sort mygrid
scatter ehat_min ehat ehat_max mygrid, ///
	xtitle("Democratic vote share (%)") ytitle("") ///
	ms(i i i) c(l l l) lp(- l -) lc(black black black) legend(off) xline(50, lpattern(.)) ///
	graphregion(fcolor(white) lcolor(white)) subtitle("(b) Semi-parametric", pos(11))  ylabel(,nogrid)
graph save output/figures/amountVsVoteShare_semiParametric2.gph, replace
restore

* combine and export
graph combine output/figures/amountVsVoteShare_nonParametric.gph output/figures/amountVsVoteShare_semiParametric2.gph, graphregion(fcolor(white) lcolor(white)) l1title("Dollars per worker")
graph export output/figures/Figure5.$figureFormat, replace

* clean up
cap erase output/figures/amountVsVoteShare_nonParametric.gph 
cap erase output/figures/amountVsVoteShare_semiParametric2.gph

clear


