


********************************************************
*** a. Amount per resident vs. Democratic vote share ***
********************************************************

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

twoway (scatter amtpc demVoteSh_house, mc(black) ) ///
	   , legend(off) ///
	   graphregion(fcolor(white) lcolor(white)) subtitle("(a) Amount per resident", pos(11)) ///
	   xtitle("Democratic vote share (%)") ytitle("Dollars per resident") ylabel(0(2000)4000,nogrid)
graph save output/figures/amountPerResident_vsVoteShare.gph, replace


******************************************************
*** b. Amount per worker vs. Democratic vote share ***
******************************************************

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

twoway (scatter amtpw demVoteSh_house, mc(black) ) ///
	   , legend(off) ///
	   graphregion(fcolor(white) lcolor(white)) subtitle("(b) Amount per worker", pos(11)) ///
	   xtitle("Democratic vote share (%)") ytitle("Dollars per worker") ylabel(,nogrid) 
graph save output/figures/amountPerWorker_vsVoteShare.gph, replace


************************************************
*** c. Amount per resident vs. percent urban ***
************************************************

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

twoway (scatter amtpc pcturban if dem==1, mc(blue) msym(D) ) ///
	   (scatter amtpc pcturban if dem==0, mc(red)  msym(O) )  ///
	   , legend(order(1 "Democrats" 2 "Republicans")) ///
	   subtitle("(c) Amount per resident vs. percent urban", pos(11)) ///
	   graphregion(fcolor(white) lcolor(white)) graphregion(fcolor(white)) ///
	   xtitle("Percent Urban") ytitle("Dollars per resident") ylabel(0(2000)4000,nogrid) 
graph save output/figures/amountVsPercentUrban2.gph, replace


*****************************************************************************
*** d. Worker-per-resident vs. Democratic vote share (nonparametric plot) ***
*****************************************************************************

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

gen emptopop = dist_emp / pop

twoway lpolyci emptopop demVoteSh_house, ciplot(rline) alp(dash) acolor(black) clc(black) legend(off) ///
	   xtitle("Democratic vote share (%)") ytitle("# Workers / # Residents") ///
	   graphregion(fcolor(white) lcolor(white)) ylabel(,nogrid) subtitle("(d) Worker-to-resident ratio", pos(11)) 
graph save output/figures/nonparametric_workerToResident_vsVoteShare.gph, replace



******************************************************
*** Combine figures into one, export, and clean up ***
******************************************************

graph combine output/figures/amountPerResident_vsVoteShare.gph output/figures/amountPerWorker_vsVoteShare.gph ///
	output/figures/amountVsPercentUrban2.gph output/figures/nonparametric_workerToResident_vsVoteShare.gph ///
	, graphregion(fcolor(white) lcolor(white)) 
graph export output/figures/Figure3.$figureFormat, replace


erase output/figures/amountPerResident_vsVoteShare.gph 
erase output/figures/amountPerWorker_vsVoteShare.gph 
erase output/figures/amountVsPercentUrban2.gph 
erase output/figures/nonparametric_workerToResident_vsVoteShare.gph 






