


use data/district_level_data, clear

* drop state capitals
drop if iscap==1

* dummy variable for outliers, per resident and per worker
gen outlier_pc = amtpc>1300 & amtpc<.
gen outlier_pw = amtpw>3500 & amtpw<.

* figure labels for outliers
gen outlierlabel_pw = lastname + " (" + stateabbrev + ")" if outlier_pw==1
gen outlierlabel_pc = lastname + " (" + stateabbrev + ")" if outlier_pc==1

* figure label positions
gen outlierlabpos_pw = 2
replace outlierlabpos_pw = 11 if lastname=="Hastings"
replace outlierlabpos_pw = 6 if lastname=="McKeon"
replace outlierlabpos_pw = 12 if lastname=="Cummings"
replace outlierlabpos_pw = 6 if lastname=="Lee"

* panel A
tw (scatter amtpc demVoteSh_house if outlier_pc==0, mc(gs12)) ///
(scatter amtpc demVoteSh_house if outlier_pc==1, mc(gs1) mlabel(outlierlabel_pw) mlabv(outlierlabpos_pw)), ///
yline(1300,lp(-)) legend(off) subtitle("(a) Amount per resident",pos(11)) ytitle("Stimulus amount per resident ($)") ///
graphregion(fcolor(white) lcolor(white)) ylabel(,nogrid) ///
xtitle("Democratic vote share") saving(output/figures/g1.gph,replace) 

* panel B
tw (scatter amtpw demVoteSh_house if outlier_pw==0, mc(gs12)) ///
(scatter amtpw demVoteSh_house if outlier_pw==1, mc(gs1) mlabel(outlierlabel_pw) mlabv(outlierlabpos_pw)), ///
yline(3500,lp(-)) legend(off) subtitle("(b) Amount per worker",pos(11)) ytitle("Stimulus amount per worker ($)") ///
graphregion(fcolor(white) lcolor(white)) ylabel(,nogrid) ///
xtitle("Democratic vote share") saving(output/figures/g2.gph,replace)

* combine and export
graph combine output/figures/g1.gph output/figures/g2.gph, graphregion(fcolor(white) lcolor(white)) 
graph export output/figures/Figure2.$figureFormat, replace

* clean up
erase output/figures/g1.gph
erase output/figures/g2.gph

