


use data/district_level_data,clear

* drop state capitals
drop if iscap==1

* panel A
hist amtpc, saving(output/figures/hist1.gph, replace) freq kdensity xtitle("") ///
graphregion(fcolor(white) lcolor(white)) ///
subtitle("(a) Amount per resident ($)", pos(11)) ytitle("") ylabel(,nogrid)

* panel B
hist demVoteSh_house, saving(output/figures/hist2.gph, replace) freq kdensity xtitle("") ///
graphregion(fcolor(white) lcolor(white)) ///
subtitle("(b) Democratic vote share (%)", pos(11)) ytitle("") ylabel(,nogrid)

* combine and export
graph combine output/figures/hist1.gph output/figures/hist2.gph, graphregion(fcolor(white) lcolor(white))
graph export output/figures/Figure1.$figureFormat, replace

* clean up
erase output/figures/hist1.gph
erase output/figures/hist2.gph

