* use this file to replicate the tables in Boone, Dube and Kaplan (2014)
* this is Stata code
* last updated 2015.02.28

* TO RUN THIS PROGRAM:
*   -- you must enter the correct file path in section 0 to set "/BooneDubeKaplan" as your working directory


**************************
**** 0. prepare stata ****
**************************
clear all
macro drop _all
set more off 

** MUST CHANGE THE FILE PATH BELOW TO THE APPROPRIATE DIRECTORY! **
cd "C:/Users/<CHANGE_THIS_FILE_PATH>/Downloads/BooneDubeKaplan/"

** required programs
cap ssc install estout


**************************************
**** 1. Replicate tables in paper ****
**************************************

* Table 1 - Descriptive statistics
do code/makeTables/table_1.do

* Table 2 - District-level economic targeting
do code/makeTables/table_2.do

* Table 3 - State-level economic targeting
do code/makeTables/table_3.do

* Table 4 - District-level group targeting: political party
do code/makeTables/table_4.do

* Table 5 - District-level group targeting: vote share blocks
do code/makeTables/table_5.do

* Table 6 - State-level group targeting: partisanship
do code/makeTables/table_6.do

* Table 7 - District-level individual targeting: party elites
do code/makeTables/table_7.do

* Table 8 - District-level individual targeting: party discipline and pivotal members
do code/makeTables/table_8.do

* Table 9 - State-level individual targeting: party elites and pivotal members
do code/makeTables/table_9.do


************************************************
**** 2. Replicate tables in online appendix ****
************************************************

* Table A3 - District-level stimulus amount: other controls
do code/makeTables/table_A3.do

* Table A4 - District-level regressions: party elites (House of Representatives)
do code/makeTables/table_A4.do

* Table A5 - District-level small sample tests: House of Representatives
do code/makeTables/table_A5.do

* Table A6 - State-level regressions: stimulus amount vs. party elites (Senate)
do code/makeTables/table_A6.do

* Table A7 - District-level regressions: voting against party and party of governor
do code/makeTables/table_A7.do

clear

