

************************
*** prepare data set ***
************************

use data/district_level_data, clear

* drop state capitals
drop if iscap==1

gen arrayes = vote=="Yea"

* get arra votes, including not voting
* the following districts abstained from ARRA votes: 0648, 3626, 4506 (capital district)
gen arraVote = arrayes
replace arraVote = 2 if district=="0648" | district=="3626" | district=="4506"
* the following districts didn't have any representatives, so there was no vote
replace arraVote = . if district=="1705" | district=="3620"
gen arraVoteAgainstParty = 0
replace arraVoteAgainstParty = . if district=="1705" | district=="3620"
replace arraVoteAgainstParty = 1 if dem==1 & inlist(arraVote,0)
replace arraVoteAgainstParty = 1 if dem==0 & inlist(arraVote,1)
gen arraVoteAgainst_inclAbstain = 0
replace arraVoteAgainst_inclAbstain = . if district=="1705" | district=="3620"
replace arraVoteAgainst_inclAbstain = 1 if dem==1 & inlist(arraVote,0,2)
replace arraVoteAgainst_inclAbstain = 1 if dem==0 & inlist(arraVote,1,2)
gen againstParty = arraVoteAgainstParty
gen demAgainst = arraVoteAgainstParty==1 & dem==1
gen demAgainstXdemGov = demAgainst*demGov

* label some vars
label var demAgainst        "Democrat voting against"
label var percentPoverty "\% poverty"
label var pcturban "\% urban"
label var demGov "Democratic Governor" 
label var demAgainstXdemGov "(Dem Vote No)*(Dem Gov)"

* create vote share group dummies
gen v5dum1  = demVoteSh_house==0
gen v5dum2  = demVoteSh_house>0 & demVoteSh_house<30
gen v5dum3  = demVoteSh_house>=30 & demVoteSh_house<40
gen v5dum4  = demVoteSh_house>=40 & demVoteSh_house<50
gen v5dum5  = demVoteSh_house>=50 & demVoteSh_house<60
gen v5dum6  = demVoteSh_house>=60 & demVoteSh_house<70
gen v5dum7  = demVoteSh_house>=70 & demVoteSh_house<80
gen v5dum8  = demVoteSh_house>=80 & demVoteSh_house<90
gen v5dum9  = demVoteSh_house>=90 & demVoteSh_house<100
gen v5dum10  = demVoteSh_house==100
label var v5dum1 "Unopposed Repub (13)"
label var v5dum2 "Dem vote share 1-30 (16) "
label var v5dum3 "Dem vote share 30-40 (63)"
label var v5dum4 "Dem vote share 40-50 (46)"
label var v5dum5 "Dem vote share 50-60 (42)"
label var v5dum6 "Dem vote share 60-70 (44)"
label var v5dum7 "Dem vote share 70-80 (51)"
label var v5dum8 "Dem vote share 80-90 (20)"
label var v5dum9 "Dem vote share 90-99 (5)"
label var v5dum10 "Unopposed Dem (34)"


***********************
*** run regressions ***
***********************

estimates clear

qui eststo: reg amtpc demGov, cluster(statefips)
qui eststo: reg amtpc demAgainst  , cluster(statefips)
qui eststo: reg amtpc demAgainst demGov, cluster(statefips)
qui eststo: reg amtpc demAgainst demGov demAgainstXdemGov, cluster(statefips)
qui eststo: reg amtpc demGov v5dum1-v5dum4 v5dum6-v5dum10 dist_emp_th percentPoverty pcturban larea totalmiles , cluster(statefips)
qui estadd local vscontrols = "X"
qui estadd local controls = "X"
qui eststo: reg amtpc demAgainst v5dum1-v5dum4 v5dum6-v5dum10 dist_emp_th percentPoverty pcturban larea totalmiles , cluster(statefips)
qui estadd local vscontrols = "X"
qui estadd local controls = "X"
qui eststo: reg amtpc demAgainst demGov v5dum1-v5dum4 v5dum6-v5dum10 dist_emp_th percentPoverty pcturban larea totalmiles , cluster(statefips)
qui estadd local vscontrols = "X"
qui estadd local controls = "X"
qui eststo: reg amtpc demAgainst demGov demAgainstXdemGov v5dum1-v5dum4 v5dum6-v5dum10 dist_emp_th percentPoverty pcturban larea totalmiles , cluster(statefips)
qui estadd local vscontrols = "X"
qui estadd local controls = "X"


******************
*** save table ***
******************

esttab * using output/tables/TableA7.tex, replace se r2 label booktabs star(* 0.10 ** 0.05 *** 0.01) ///
nonotes ///
keep( demGov demAgainst demAgainstXdemGov) ///
scalar("vscontrols Vote share controls" "controls Additional controls") ///
mgroups("Per Resident" , pattern(1 0 0 0 0 0 0 0) ///
prefix(\multicolumn{@span}{c}{) suffix(})   ///
span erepeat(\cmidrule(lr){@span}))         ///
nomtitles


