


************************
*** prepare data set ***
************************

use data/state_level_data,clear

* change units
gen _interstate2005percap = interstate2005percap*10000

* create some variables
gen senate_dem_leader = 0
replace senate_dem_leader = 1 if inlist(stateabbrev,"ND" ,"HI" ,"CT" ,"CA" ,"NM" ,"MA" ,"MI" ,"NY")
replace senate_dem_leader = 1 if inlist(stateabbrev,"IA" ,"LA" ,"WV" ,"MT" ,"SD" ,"WI" ,"UT" ,"IL")

gen senate_repub_leader = 0
replace senate_repub_leader = 1 if inlist(stateabbrev,"KY" ,"AZ" ,"GA" ,"MS" ,"AL" ,"NH" ,"TX" ,"AK")
replace senate_repub_leader = 1 if inlist(stateabbrev,"OK" ,"IN" ,"WY" ,"ME" ,"PA" ,"NC" ,"OR" ,"MO")

label var senate_dem_leader "Democratic leader"
label var senate_repub_leader "Republican leader"

***********************
*** run regressions ***
***********************

estimates clear
qui eststo: reg fundsawarded_pc senate_dem_leader senate_repub_leader, vce(robust)
qui estadd local capitals = "X"
qui eststo: reg fundsawarded_pc senate_dem_leader senate_repub_leader  medpercap2005 _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
qui estadd local capitals = "X"
qui estadd local controls = "X"
qui eststo: reg amtpc_Prime_popTotal_wcap senate_dem_leader senate_repub_leader  medpercap2005 _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
qui estadd local capitals = "X"
qui estadd local controls = "X"
qui eststo: reg amtpc_Prime_popTotal_nocap senate_dem_leader senate_repub_leader  medpercap2005 _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
qui estadd local controls = "X"



******************
*** save table ***
******************

esttab * using output/tables/TableA6.tex, replace booktabs se r2 label star(* 0.10 ** 0.05 *** 0.01) ///
mtitles("Agency" "Agency" "CGL" "CGL") ///
scalar("capitals Includes state capitals" "controls Additional controls") ///
keep( senate_dem_leader senate_repub_leader) ///
order(senate_dem_leader senate_repub_leader) 



