


************************
*** prepare data set ***
************************

** first, get data set containing stimulus amount by district 
tempfile recovAmt_committeeTests
use data/district_level_data, clear
keep district amtpc_Prime_popTotal
rename amtpc_Prime_popTotal amtpc
save `recovAmt_committeeTests',replace


** now create data set containing districts pairs to compare
clear
set obs 21
gen pair = _n

* input list of relevant district pairs
* 0612, 0637, 3911, 5507, 2904, 4505, 3610, 4706, 0616, 3615, 4816, 5106, 0652, 5111, 2603, 3901, 2204, 0641, 4806, 1804, 2602
* 0628, 4201, 0616, 5306, 5309, 2408, 2407, 4830, 0639, 2612, 2402, 4003, 3623, 0649, 0603, 2906, 2604, 2105, 2606, 1201, 4813
input dist1 dist2
612 628
637 4201
3911 616
5507 5306
2904 5309
4505 2408
3610 2407
4706 4830
616 639
3615 2612
4816 2402
5106 4003
652 3623
5111 649
2603 603
3901 2906
2204 2604
641 2105
4806 2606
1804 1201
2602 4813


* merge in stimulus amounts
tostring dist1, gen(district)
replace district = "0"+district if length(district)<4
merge 1:1 district using `recovAmt_committeeTests'
drop if _m==2
drop _m
rename amtpc amtpc1
drop district

tostring dist2, gen(district)
replace district = "0"+district if length(district)<4
merge 1:1 district using `recovAmt_committeeTests'
drop if _m==2
drop _m
rename amtpc amtpc2
drop district


**********************************
*** run tests and store output ***
**********************************

sort pair
gen more=0

* expand data set
expand 2

* Feb2009 is indicator for whether the district was represented 
* by a committee chair during the ARRA passage
bys pair: gen Feb2009 = _n-1

** get binary variable "more" indicating which district received higher ARRA funds

* for Democrats:
* compare 110th vs 111th Congress
* 0612, 0637, 3911
* 0628, 4201, 0616
gen dem1 = pair>=1 & pair<=3
replace more = 1 if dem1==1 & Feb2009==0 & amtpc1>amtpc2
replace more = 1 if dem1==1 & Feb2009==1 & amtpc2>amtpc1
* compare 111th vs 112th Congress 
* 5507, 2904, 4505, 3610, 4706, 0616, 3615, 4816
* 5306, 5309, 2408, 2407, 4830, 0639, 2612, 2402
gen dem2 = pair>=4 & pair<=11
replace more = 1 if dem2==1 & Feb2009==0 & amtpc2>amtpc1
replace more = 1 if dem2==1 & Feb2009==1 & amtpc1>amtpc2

* for Republicans:
* compare 110th vs 111th Congress
* 5106, 0652, 5111, 2603, 3901, 2204
* 4003, 3623, 0649, 0603, 2906, 2604
gen repub1 = pair>=12 & pair<=17
replace more = 1 if repub1==1 & Feb2009==0 & amtpc1>amtpc2
replace more = 1 if repub1==1 & Feb2009==1 & amtpc2>amtpc1
* compare 111th vs 112th Congress 
* 0641, 4806, 1804, 2602
* 2105, 2606, 1201, 4813
gen repub2 = pair>=18 & pair<=21
replace more = 1 if repub2==1 & Feb2009==0 & amtpc2>amtpc1
replace more = 1 if repub2==1 & Feb2009==1 & amtpc1>amtpc2


** run comparisons to see whether chair serving during Feb 2009 received higher amount of funding

rename more more_stimulus_per_cap

ta Feb2009 more_stimulus_per_cap if dem1==1, exact matrow(mrow) matcol(mcol) matcell(d1)
local d1p1 : display %7.2f r(p1_exact)
local d1p2 : display %7.2f r(p_exact)
mac lis 
ta Feb2009 more_stimulus_per_cap if dem2==1, exact matrow(mrow) matcol(mcol) matcell(d2)
local d2p1 : display %7.2f r(p1_exact)
local d2p2 : display %7.2f r(p_exact)
mac lis 
ta Feb2009 more_stimulus_per_cap if dem1==1 | dem2==1, exact matrow(mrow) matcol(mcol) matcell(d3)
local d3p1 : display %7.2f r(p1_exact)
local d3p2 : display %7.2f r(p_exact)
mac lis 

ta Feb2009 more_stimulus_per_cap if repub1==1, exact matrow(mrow) matcol(mcol) matcell(r1)
local r1p1 : display %7.2f r(p1_exact)
local r1p2 : display %7.2f r(p_exact)
mac lis 
ta Feb2009 more_stimulus_per_cap if repub2==1, exact matrow(mrow) matcol(mcol) matcell(r2)
local r2p1 : display %7.2f r(p1_exact)
local r2p2 : display %7.2f r(p_exact)
mac lis 
ta Feb2009 more_stimulus_per_cap if repub1==1 | repub2==1, exact matrow(mrow) matcol(mcol) matcell(r3)
local r3p1 : display %7.2f r(p1_exact)
local r3p2 : display %7.2f r(p_exact)
mac lis 



********************************
*** write output to tex file ***
********************************

cap file close myfile
file open myfile using output/tables/TableA5.tex, write replace

local d1pct : display %7.2f `=d1[2,2]/(d1[2,1]+d1[2,2])'
local d2pct : display %7.2f `=d2[2,2]/(d2[2,1]+d2[2,2])'
local d3pct : display %7.2f `=d3[2,2]/(d3[2,1]+d3[2,2])'
local r1pct : display %7.2f `=r1[2,2]/(r1[2,1]+r1[2,2])'
local r2pct : display %7.2f `=r2[2,2]/(r2[2,1]+r2[2,2])'
local r3pct : display %7.2f `=r3[2,2]/(r3[2,1]+r3[2,2])'

file write myfile "{" _n
file write myfile "\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" _n
file write myfile "\begin{tabular}{l*{3}{c}}" _n
file write myfile "\toprule" _n
file write myfile "                    &\multicolumn{3}{p{7.5cm}}{Compare district of 111th committee leaders to districts represented by committee leaders in...}         \\" _n
file write myfile "\noalign{\smallskip}" _n
file write myfile "                    &\multicolumn{1}{c}{110th Congress}         &\multicolumn{1}{c}{112th Congress}         &\multicolumn{1}{c}{110th or 112th}    \\" _n
file write myfile "" _n
file write myfile "\midrule" _n
file write myfile "" _n
file write myfile "\multicolumn{1}{l}{\textbf{\emph{Democrats}}} \\ " _n
file write myfile "\noalign{\smallskip}" _n
file write myfile "" _n
file write myfile "No. of cases                                        &   `=d1[2,1]+d1[2,2]'    &   `=d2[2,1]+d2[2,2]'  &   `=d3[2,1]+d3[2,2]'   \\" _n
file write myfile "No. of times 111th leader receives more              &   `=d1[2,2]'            &   `=d2[2,2]'          &   `=d3[2,2]'           \\" _n
file write myfile "Percentage                                          &   `d1pct'               &   `d2pct'             &   `d3pct'              \\" _n
file write myfile "p-value:                 &                         &                       &                        \\" _n
file write myfile "\hspace{5pt} 1-sided test                                      &   `d1p1'                &   `d2p1'              &   `d3p1'               \\" _n
file write myfile "\hspace{5pt} 2-sided test                                      &   `d1p2'                &   `d2p2'              &   `d3p2'               \\" _n
file write myfile "\\" _n
file write myfile "\multicolumn{1}{l}{\textbf{\emph{Republicans}}} \\ " _n
file write myfile "\noalign{\smallskip}" _n
file write myfile "" _n
file write myfile "No. of cases                                        &   `=r1[2,1]+r1[2,2]'    &   `=r2[2,1]+r2[2,2]'  &   `=r3[2,1]+r3[2,2]'   \\" _n
file write myfile "No. of times 111th leader receives more              &   `=r1[2,2]'            &   `=r2[2,2]'          &   `=r3[2,2]'           \\" _n
file write myfile "Percentage                                          &   `r1pct'               &   `r2pct'             &   `r3pct'              \\" _n
file write myfile "p-value:                 &                         &                       &                        \\" _n
file write myfile "\hspace{5pt} 1-sided test                                      &   `r1p1'                &   `r2p1'              &   `r3p1'               \\" _n
file write myfile "\hspace{5pt} 2-sided test                                      &   `r1p2'                &   `r2p2'              &   `r3p2'               \\" _n
file write myfile "" _n
file write myfile "\addlinespace" _n
file write myfile "\bottomrule" _n
file write myfile "\end{tabular}" _n
file write myfile "}" _n

cap file close myfile


