

************************
*** prepare data set ***
************************

use data/district_level_data, clear

* drop state capitals
drop if iscap==1

* label some vars
label var percentPoverty "Percent Poverty"
label var larea "Land Area"
label var totalmiles "Total Highway miles"

***********************
*** run regressions ***
***********************

estimates clear

qui eststo: reg amtpc percentPoverty , cluster(statefips)
qui eststo: reg amtpc pcturban , cluster(statefips)
qui eststo: reg amtpc larea  , cluster(statefips)
qui eststo: reg amtpc totalmiles, cluster(statefips)
qui eststo: reg amtpw percentPoverty , cluster(statefips)
qui eststo: reg amtpw pcturban , cluster(statefips)
qui eststo: reg amtpw larea  , cluster(statefips)
qui eststo: reg amtpw totalmiles, cluster(statefips)

******************
*** save table ***
******************

esttab * using output/tables/TableA3.tex, replace se r2 label booktabs star(* 0.10 ** 0.05 *** 0.01) ///
nonotes ///
mgroups("Per Resident" "Per Worker" , pattern(1 0 0 0 1 0 0 0) ///
prefix(\multicolumn{@span}{c}{) suffix(})   ///
span erepeat(\cmidrule(lr){@span}))         ///
nomtitles
