

************************
*** prepare data set ***
************************

use data/district_level_data, clear

* drop state capitals
drop if iscap==1

* get indicator for McKeon or Hastings district
gen mckeon_hastings = inlist(lastname,"McKeon","Hastings") & inlist(stateabbrev,"CA","WA")
label var mckeon_hastings "McKeon, Hastings"

* label some vars
label var isChairOrDemLeader "Democratic leader"
label var isRmOrRepLeader "Republican leader"
label var ischair "Committee chair (D)"
label var isrm "Ranking member (R)"
label var isleaderdem "Pelosi"
label var isleaderrep "Boehner"
label var nterms_house "Number of terms"

* create vote share group dummies
gen v5dum1  = demVoteSh_house==0
gen v5dum2  = demVoteSh_house>0 & demVoteSh_house<30
gen v5dum3  = demVoteSh_house>=30 & demVoteSh_house<40
gen v5dum4  = demVoteSh_house>=40 & demVoteSh_house<50
gen v5dum5  = demVoteSh_house>=50 & demVoteSh_house<60
gen v5dum6  = demVoteSh_house>=60 & demVoteSh_house<70
gen v5dum7  = demVoteSh_house>=70 & demVoteSh_house<80
gen v5dum8  = demVoteSh_house>=80 & demVoteSh_house<90
gen v5dum9  = demVoteSh_house>=90 & demVoteSh_house<100
gen v5dum10  = demVoteSh_house==100
label var v5dum1 "Unopposed Repub (13)"
label var v5dum2 "Dem vote share 1-30 (16) "
label var v5dum3 "Dem vote share 30-40 (63)"
label var v5dum4 "Dem vote share 40-50 (46)"
label var v5dum5 "Dem vote share 50-60 (42)"
label var v5dum6 "Dem vote share 60-70 (44)"
label var v5dum7 "Dem vote share 70-80 (51)"
label var v5dum8 "Dem vote share 80-90 (20)"
label var v5dum9 "Dem vote share 90-99 (5)"
label var v5dum10 "Unopposed Dem (34)"


***********************
*** run regressions ***
***********************

estimates clear
qui eststo: reg amtpc   isChairOrDemLeader isRmOrRepLeader, cluster(statefips)
qui estadd local vscontrols = ""
qui estadd local controls = ""
qui eststo: reg amtpc v5dum1-v5dum4 v5dum6-v5dum10 dist_emp_th percentPoverty pcturban larea totalmiles isChairOrDemLeader isRmOrRepLeader, cluster(statefips)
qui estadd local vscontrols = "X"
qui estadd local controls = "X"
qui eststo: reg amtpw   isChairOrDemLeader isRmOrRepLeader, cluster(statefips)
qui estadd local vscontrols = ""
qui estadd local controls = ""
qui eststo: reg amtpw v5dum1-v5dum4 v5dum6-v5dum10 percentPoverty pcturban larea totalmiles isChairOrDemLeader isRmOrRepLeader, cluster(statefips)
qui estadd local vscontrols = "X"
qui estadd local controls = "X"

qui eststo: reg amtpc   nterms_house, cluster(statefips)
qui estadd local vscontrols = ""
qui estadd local controls = ""
qui eststo: reg amtpc v5dum1-v5dum4 v5dum6-v5dum10 dist_emp_th percentPoverty pcturban larea totalmiles nterms_house, cluster(statefips)
qui estadd local vscontrols = "X"
qui estadd local controls = "X"
qui eststo: reg amtpw   nterms_house, cluster(statefips)
qui estadd local vscontrols = ""
qui estadd local controls = ""
qui eststo: reg amtpw v5dum1-v5dum4 v5dum6-v5dum10  percentPoverty pcturban larea totalmiles nterms_house, cluster(statefips)
qui estadd local vscontrols = "X"
qui estadd local controls = "X"


******************
*** save table ***
******************

esttab * using output/tables/Table7.tex, replace se r2 label booktabs star(* 0.10 ** 0.05 *** 0.01) ///
nonotes ///
keep( isChairOrDemLeader isRmOrRepLeader nterms_house ) ///
order(isChairOrDemLeader isRmOrRepLeader nterms_house ) ///
scalar("vscontrols Vote share controls" "controls Additional controls") ///
mgroups("Per Resident" "Per Worker" "Per Resident" "Per Worker" , pattern(1 0 1 0 1 0 1 0) ///
prefix(\multicolumn{@span}{c}{) suffix(})   ///
span erepeat(\cmidrule(lr){@span}))         ///
/// mtitles("per res" "per res" "per worker" "per worker" "per res" "per res" "per worker" "per worker" )
nomtitles

