


************************
*** prepare data set ***
************************

use data/state_level_data,clear

* change units
gen _interstate2005percap = interstate2005percap*10000


*********************************
*** open file to write output ***
*********************************


cap file close myfile
file open myfile using output/tables/tmp.tex, write replace

file write myfile "\begin{tabular}{l c c c } \toprule" _n
file write myfile "\multicolumn{1}{c}{Independent Variable:} 	& Change in  	& State 		& Percent 	\\ " _n
file write myfile "\multicolumn{1}{c}{} 						& unemployment  & Employment 	& Poverty  	\\ " _n
file write myfile "\midrule \noalign{\smallskip}" _n



*********************************************
*** Panel A. Agency-reported, no controls ***
*********************************************

file write myfile "\multicolumn{4}{l}{\textbf{\emph{Panel (a): Amount per resident -- Agency-reported}}} \\ \noalign{\smallskip}" _n

qui reg fundsawarded_pc change_unemp_jan_07_09, vce(robust)
local b1 : display %7.2f `=_b[change_unemp_jan_07_09]'
local s1 : display %7.2f `=_se[change_unemp_jan_07_09]'
local p1 = (2 * ttail(e(df_r), abs(_b[change_unemp_jan_07_09]/_se[change_unemp_jan_07_09]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg fundsawarded_pc state_emp_per_res, vce(robust)
local b2 : display %7.2f `=_b[state_emp_per_res]'
local s2 : display %7.2f `=_se[state_emp_per_res]'
local p2 = (2 * ttail(e(df_r), abs(_b[state_emp_per_res]/_se[state_emp_per_res]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg fundsawarded_pc percent_poverty, vce(robust)
local b3 : display %7.2f `=_b[percent_poverty]'
local s3 : display %7.2f `=_se[percent_poverty]'
local p3 = (2 * ttail(e(df_r), abs(_b[percent_poverty]/_se[percent_poverty]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg fundsawarded_pc demGov, vce(robust)
local b4 : display %7.2f `=_b[demGov]'
local s4 : display %7.1f `=_se[demGov]'
local p4 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg fundsawarded_pc avg_tenure_congress , vce(robust)
local b5 : display %7.2f `=_b[avg_tenure_congress]'
local s5 : display %7.3f `=_se[avg_tenure_congress]'
local p5 = (2 * ttail(e(df_r), abs(_b[avg_tenure_congress]/_se[avg_tenure_congress]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg fundsawarded_pc gang4, vce(robust)
local b6 : display %7.2f `=_b[gang4]'
local s6 : display %7.1f `=_se[gang4]'
local p6 = (2 * ttail(e(df_r), abs(_b[gang4]/_se[gang4]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg fundsawarded_pc specter_nelson, vce(robust)
local b7 : display %7.1f `=_b[specter_nelson]'
local s7 : display %7.1f `=_se[specter_nelson]'
local p7 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " No controls & `b1'`star1' & `b2'`star2' & `b3'`star3'  \\" _n
file write myfile "  & (`s1') & (`s2') & (`s3') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r3'  \\" _n
file write myfile " Observations 	& `n1' & `n2' & `n3' \\" _n
file write myfile "\noalign{\smallskip}" _n


***********************************************
*** Panel B. Agency-reported, with controls ***
***********************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{4}{l}{\textbf{\emph{Panel (b): Amount per resident -- Agency-reported}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg fundsawarded_pc change_unemp_jan_07_09  medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
local b1 : display %7.3f `=_b[change_unemp_jan_07_09]'
local s1 : display %7.2f `=_se[change_unemp_jan_07_09]'
local p1 = (2 * ttail(e(df_r), abs(_b[change_unemp_jan_07_09]/_se[change_unemp_jan_07_09]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg fundsawarded_pc state_emp_per_res medpercap2005 DemVoteShare _interstate2005percap  percent_poverty, vce(robust)
local b2 : display %7.2f `=_b[state_emp_per_res]'
local s2 : display %7.2f `=_se[state_emp_per_res]'
local p2 = (2 * ttail(e(df_r), abs(_b[state_emp_per_res]/_se[state_emp_per_res]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg fundsawarded_pc percent_poverty medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res , vce(robust)
local b3 : display %7.2f `=_b[percent_poverty]'
local s3 : display %7.2f `=_se[percent_poverty]'
local p3 = (2 * ttail(e(df_r), abs(_b[percent_poverty]/_se[percent_poverty]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg fundsawarded_pc demGov medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b4 : display %7.3f `=_b[demGov]'
local s4 : display %7.2f `=_se[demGov]'
local p4 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg fundsawarded_pc avg_tenure_congress medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b5 : display %7.2f `=_b[avg_tenure_congress]'
local s5 : display %7.3f `=_se[avg_tenure_congress]'
local p5 = (2 * ttail(e(df_r), abs(_b[avg_tenure_congress]/_se[avg_tenure_congress]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg fundsawarded_pc gang4 medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b6 : display %7.1f `=_b[gang4]'
local s6 : display %7.1f `=_se[gang4]'
local p6 = (2 * ttail(e(df_r), abs(_b[gang4]/_se[gang4]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg fundsawarded_pc specter_nelson medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b7 : display %7.1f `=_b[specter_nelson]'
local s7 : display %7.1f `=_se[specter_nelson]'
local p7 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " With controls & `b1'`star1' & `b2'`star2' & `b3'`star3'  \\" _n
file write myfile "  	& (`s1') & (`s2') & (`s3') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r3' \\" _n
file write myfile " Observations 	& `n1' & `n2' & `n3' \\" _n
file write myfile "\noalign{\smallskip}" _n



*************************************************************************
*** Panel C. Contracts grants and loans, with controls, with capitals ***
*************************************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{4}{l}{\textbf{\emph{Panel (c): Amount per resident -- Contracts, Grants, Loans}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg amtpc_Prime_popTotal_wcap change_unemp_jan_07_09  medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
local b1 : display %7.2f `=_b[change_unemp_jan_07_09]'
local s1 : display %7.2f `=_se[change_unemp_jan_07_09]'
local p1 = (2 * ttail(e(df_r), abs(_b[change_unemp_jan_07_09]/_se[change_unemp_jan_07_09]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap state_emp_per_res medpercap2005 DemVoteShare _interstate2005percap  percent_poverty, vce(robust)
local b2 : display %7.2f `=_b[state_emp_per_res]'
local s2 : display %7.2f `=_se[state_emp_per_res]'
local p2 = (2 * ttail(e(df_r), abs(_b[state_emp_per_res]/_se[state_emp_per_res]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap percent_poverty medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res , vce(robust)
local b3 : display %7.2f `=_b[percent_poverty]'
local s3 : display %7.2f `=_se[percent_poverty]'
local p3 = (2 * ttail(e(df_r), abs(_b[percent_poverty]/_se[percent_poverty]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap demGov medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b4 : display %7.1f `=_b[demGov]'
local s4 : display %7.2f `=_se[demGov]'
local p4 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap avg_tenure_congress medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b5 : display %7.2f `=_b[avg_tenure_congress]'
local s5 : display %7.3f `=_se[avg_tenure_congress]'
local p5 = (2 * ttail(e(df_r), abs(_b[avg_tenure_congress]/_se[avg_tenure_congress]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap gang4 medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b6 : display %7.1f `=_b[gang4]'
local s6 : display %7.2f `=_se[gang4]'
local p6 = (2 * ttail(e(df_r), abs(_b[gang4]/_se[gang4]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_wcap specter_nelson medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b7 : display %7.1f `=_b[specter_nelson]'
local s7 : display %7.2f `=_se[specter_nelson]'
local p7 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " With controls & `b1'`star1' & `b2'`star2' & `b3'`star3' \\" _n
file write myfile "  	& (`s1') & (`s2') & (`s3') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r3' \\" _n
file write myfile " Observations 	& `n1' & `n2' & `n3' \\" _n
file write myfile "\noalign{\smallskip}" _n




***********************************************************************
*** Panel D. Contracts grants and loans, with controls, no capitals ***
***********************************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{4}{l}{\textbf{\emph{Panel (d): Amount per resident -- Contracts, Grants, Loans}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg amtpc_Prime_popTotal_nocap change_unemp_jan_07_09  medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty , vce(robust)
local b1 : display %7.2f `=_b[change_unemp_jan_07_09]'
local s1 : display %7.2f `=_se[change_unemp_jan_07_09]'
local p1 = (2 * ttail(e(df_r), abs(_b[change_unemp_jan_07_09]/_se[change_unemp_jan_07_09]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap state_emp_per_res medpercap2005 DemVoteShare _interstate2005percap  percent_poverty, vce(robust)
local b2 : display %7.2f `=_b[state_emp_per_res]'
local s2 : display %7.2f `=_se[state_emp_per_res]'
local p2 = (2 * ttail(e(df_r), abs(_b[state_emp_per_res]/_se[state_emp_per_res]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap percent_poverty medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res , vce(robust)
local b3 : display %7.2f `=_b[percent_poverty]'
local s3 : display %7.2f `=_se[percent_poverty]'
local p3 = (2 * ttail(e(df_r), abs(_b[percent_poverty]/_se[percent_poverty]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap demGov medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b4 : display %7.1f `=_b[demGov]'
local s4 : display %7.2f `=_se[demGov]'
local p4 = (2 * ttail(e(df_r), abs(_b[demGov]/_se[demGov]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap avg_tenure_congress medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b5 : display %7.2f `=_b[avg_tenure_congress]'
local s5 : display %7.3f `=_se[avg_tenure_congress]'
local p5 = (2 * ttail(e(df_r), abs(_b[avg_tenure_congress]/_se[avg_tenure_congress]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap gang4 medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b6 : display %7.1f `=_b[gang4]'
local s6 : display %7.2f `=_se[gang4]'
local p6 = (2 * ttail(e(df_r), abs(_b[gang4]/_se[gang4]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg amtpc_Prime_popTotal_nocap specter_nelson medpercap2005 DemVoteShare _interstate2005percap state_emp_per_res percent_poverty, vce(robust)
local b7 : display %7.1f `=_b[specter_nelson]'
local s7 : display %7.2f `=_se[specter_nelson]'
local p7 = (2 * ttail(e(df_r), abs(_b[specter_nelson]/_se[specter_nelson]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " With controls & `b1'`star1' & `b2'`star2' & `b3'`star3' \\" _n
file write myfile " (no capitals) 	& (`s1') & (`s2') & (`s3') \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r3' \\" _n
file write myfile " Observations 	& `n1' & `n2' & `n3' \\" _n
file write myfile "\noalign{\smallskip}" _n





********************************
*** end table and close file ***
********************************

file write myfile "\bottomrule \end{tabular}" _n

cap file close myfile



*********************************************
*** delete extra spaces after parentheses ***
*********************************************


filefilter output/tables/tmp.tex output/tables/tmp1.tex, from("( ") to("(") replace
filefilter output/tables/tmp1.tex output/tables/tmp2.tex, from("( ") to("(") replace
filefilter output/tables/tmp2.tex output/tables/Table3.tex, from("( ") to("(") replace

erase output/tables/tmp.tex
erase output/tables/tmp1.tex
erase output/tables/tmp2.tex





