

* code to get p-val comes from: 
* http://www.stata.com/statalist/archive/2006-11/msg00892.html
* http://www.maartenbuis.nl/publications/p-value.pdf



************************
*** prepare data set ***
************************

* use district-level data set
use data/district_level_data, clear

* drop state capitals
drop if iscap==1

* rescale some variables
gen percent_dist_spent_1yr_100 = percent_dist_spent_1yr * 100

* label some vars
label var dist_emp_th "Employment (thousands)"
label var percent_dist_spent_1yr_100 "\% spent in 1 year"
label var percentPoverty "\% poverty"
label var pcturban "\% urban"

* create vote share group dummies
gen v5dum1  = demVoteSh_house==0
gen v5dum2  = demVoteSh_house>0 & demVoteSh_house<30
gen v5dum3  = demVoteSh_house>=30 & demVoteSh_house<40
gen v5dum4  = demVoteSh_house>=40 & demVoteSh_house<50
gen v5dum5  = demVoteSh_house>=50 & demVoteSh_house<60
gen v5dum6  = demVoteSh_house>=60 & demVoteSh_house<70
gen v5dum7  = demVoteSh_house>=70 & demVoteSh_house<80
gen v5dum8  = demVoteSh_house>=80 & demVoteSh_house<90
gen v5dum9  = demVoteSh_house>=90 & demVoteSh_house<100
gen v5dum10  = demVoteSh_house==100
label var v5dum1 "Unopposed Repub (13)"
label var v5dum2 "Dem vote share 1-30 (16) "
label var v5dum3 "Dem vote share 30-40 (63)"
label var v5dum4 "Dem vote share 40-50 (46)"
label var v5dum5 "Dem vote share 50-60 (42)"
label var v5dum6 "Dem vote share 60-70 (44)"
label var v5dum7 "Dem vote share 70-80 (51)"
label var v5dum8 "Dem vote share 80-90 (20)"
label var v5dum9 "Dem vote share 90-99 (5)"
label var v5dum10 "Unopposed Dem (34)"


*********************************
*** open file to write output ***
*********************************

cap file close myfile
file open myfile using output/tables/tmp.tex, write replace

file write myfile "\begin{tabular}{l c c c c c c c } \toprule" _n
file write myfile "\multicolumn{1}{c}{Independent Var:} 	& Unemp 	& Change in 	& UI per 	& \% spent 	& Employment	& Poverty 	& \% Urban  \\ " _n
file write myfile "\multicolumn{1}{c}{} 					& Rate 		& Unemp			& capita	& in 1 year	& (thousands)	& Rate 		&  		\\ " _n
file write myfile "\midrule \noalign{\smallskip}" _n


*************************************************
*** Panel A. Amount per resident, no controls ***
*************************************************

file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (a): Amount per resident}}} \\ \noalign{\smallskip}" _n

qui reg amtpc districtUnempRateJan09, cluster(statefips)
local b1 : display %7.3f `=_b[districtUnempRateJan09]'
local s1 : display %7.2f `=_se[districtUnempRateJan09]'
local p1 = (2 * ttail(e(df_r), abs(_b[districtUnempRateJan09]/_se[districtUnempRateJan09]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc d_unempRate_jan_07_09, cluster(statefips)
local b2 : display %7.2f `=_b[d_unempRate_jan_07_09]'
local s2 : display %7.2f `=_se[d_unempRate_jan_07_09]'
local p2 = (2 * ttail(e(df_r), abs(_b[d_unempRate_jan_07_09]/_se[d_unempRate_jan_07_09]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc uiPerCap, cluster(statefips)
local b3 : display %7.2f `=_b[uiPerCap]'
local s3 : display %7.1f `=_se[uiPerCap]'
local p3 = (2 * ttail(e(df_r), abs(_b[uiPerCap]/_se[uiPerCap]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc percent_dist_spent_1yr_100, cluster(statefips)
local b4 : display %7.2f `=_b[percent_dist_spent_1yr_100]'
local s4 : display %7.3f `=_se[percent_dist_spent_1yr_100]'
local p4 = (2 * ttail(e(df_r), abs(_b[percent_dist_spent_1yr_100]/_se[percent_dist_spent_1yr_100]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc dist_emp_th, cluster(statefips)
local b5 : display %7.3f `=_b[dist_emp_th]'
local s5 : display %7.3f `=_se[dist_emp_th]'
local p5 = (2 * ttail(e(df_r), abs(_b[dist_emp_th]/_se[dist_emp_th]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc percentPoverty, cluster(statefips)
local b6 : display %7.2f `=_b[percentPoverty]'
local s6 : display %7.3f `=_se[percentPoverty]'
local p6 = (2 * ttail(e(df_r), abs(_b[percentPoverty]/_se[percentPoverty]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg amtpc pcturban, cluster(statefips)
local b7 : display %7.3f `=_b[pcturban]'
local s7 : display %7.3f `=_se[pcturban]'
local p7 = (2 * ttail(e(df_r), abs(_b[pcturban]/_se[pcturban]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " No controls & `b1'`star1' & `b2'`star2' & `b3'`star3' & `b4'`star4' & `b5'`star5' & `b6'`star6' & `b7'`star7'  \\" _n
file write myfile "  & (`s1') & (`s2') & (`s3') & (`s4') & (`s5') & (`s6') & (`s7')  \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7'  \\" _n
file write myfile "\noalign{\smallskip}" _n


****************************************************************
*** Panel B. Amount per resident, all controls but land area ***
****************************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (b): Amount per resident}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

local covars3 percentPoverty pcturban totalmiles

qui reg amtpc districtUnempRateJan09 v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b1 : display %7.3f `=_b[districtUnempRateJan09]'
local s1 : display %7.2f `=_se[districtUnempRateJan09]'
local p1 = (2 * ttail(e(df_r), abs(_b[districtUnempRateJan09]/_se[districtUnempRateJan09]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc d_unempRate_jan_07_09 v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b2 : display %7.3f `=_b[d_unempRate_jan_07_09]'
local s2 : display %7.2f `=_se[d_unempRate_jan_07_09]'
local p2 = (2 * ttail(e(df_r), abs(_b[d_unempRate_jan_07_09]/_se[d_unempRate_jan_07_09]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc uiPerCap v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b3 : display %7.1f `=_b[uiPerCap]'
local s3 : display %7.1f `=_se[uiPerCap]'
local p3 = (2 * ttail(e(df_r), abs(_b[uiPerCap]/_se[uiPerCap]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc percent_dist_spent_1yr_100 v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b4 : display %7.2f `=_b[percent_dist_spent_1yr_100]'
local s4 : display %7.3f `=_se[percent_dist_spent_1yr_100]'
local p4 = (2 * ttail(e(df_r), abs(_b[percent_dist_spent_1yr_100]/_se[percent_dist_spent_1yr_100]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc dist_emp_th v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b5 : display %7.3f `=_b[dist_emp_th]'
local s5 : display %7.3f `=_se[dist_emp_th]'
local p5 = (2 * ttail(e(df_r), abs(_b[dist_emp_th]/_se[dist_emp_th]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc percentPoverty v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b6 : display %7.2f `=_b[percentPoverty]'
local s6 : display %7.3f `=_se[percentPoverty]'
local p6 = (2 * ttail(e(df_r), abs(_b[percentPoverty]/_se[percentPoverty]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg amtpc pcturban v5dum1-v5dum4 v5dum6-v5dum10 `covars3' dist_emp_th, cluster(statefips)
local b7 : display %7.3f `=_b[pcturban]'
local s7 : display %7.3f `=_se[pcturban]'
local p7 = (2 * ttail(e(df_r), abs(_b[pcturban]/_se[pcturban]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " All controls except 	& `b1'`star1' & `b2'`star2' & `b3'`star3' & `b4'`star4' & `b5'`star5' & `b6'`star6' & `b7'`star7'  \\" _n
file write myfile " land area		& (`s1') & (`s2') & (`s3') & (`s4') & (`s5') & (`s6') & (`s7')  \\" _n
file write myfile "\\" _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7'  \\" _n
file write myfile "\noalign{\smallskip}" _n


**************************************************
*** Panel C. Amount per resident, all controls ***
**************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (c): Amount per resident}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

local covars1 percentPoverty pcturban larea totalmiles

qui reg amtpc districtUnempRateJan09 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b1 : display %7.3f `=_b[districtUnempRateJan09]'
local s1 : display %7.2f `=_se[districtUnempRateJan09]'
local p1 = (2 * ttail(e(df_r), abs(_b[districtUnempRateJan09]/_se[districtUnempRateJan09]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpc d_unempRate_jan_07_09 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b2 : display %7.3f `=_b[d_unempRate_jan_07_09]'
local s2 : display %7.2f `=_se[d_unempRate_jan_07_09]'
local p2 = (2 * ttail(e(df_r), abs(_b[d_unempRate_jan_07_09]/_se[d_unempRate_jan_07_09]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpc uiPerCap v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b3 : display %7.1f `=_b[uiPerCap]'
local s3 : display %7.1f `=_se[uiPerCap]'
local p3 = (2 * ttail(e(df_r), abs(_b[uiPerCap]/_se[uiPerCap]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpc percent_dist_spent_1yr_100 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b4 : display %7.3f `=_b[percent_dist_spent_1yr_100]'
local s4 : display %7.3f `=_se[percent_dist_spent_1yr_100]'
local p4 = (2 * ttail(e(df_r), abs(_b[percent_dist_spent_1yr_100]/_se[percent_dist_spent_1yr_100]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpc dist_emp_th v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b5 : display %7.3f `=_b[dist_emp_th]'
local s5 : display %7.3f `=_se[dist_emp_th]'
local p5 = (2 * ttail(e(df_r), abs(_b[dist_emp_th]/_se[dist_emp_th]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpc percentPoverty v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b6 : display %7.2f `=_b[percentPoverty]'
local s6 : display %7.3f `=_se[percentPoverty]'
local p6 = (2 * ttail(e(df_r), abs(_b[percentPoverty]/_se[percentPoverty]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg amtpc pcturban v5dum1-v5dum4 v5dum6-v5dum10 `covars1' dist_emp_th, cluster(statefips)
local b7 : display %7.3f `=_b[pcturban]'
local s7 : display %7.3f `=_se[pcturban]'
local p7 = (2 * ttail(e(df_r), abs(_b[pcturban]/_se[pcturban]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " All controls  & `b1'`star1' & `b2'`star2' & `b3'`star3' & `b4'`star4' & `b5'`star5' & `b6'`star6' & `b7'`star7'  \\" _n
file write myfile " 			  & (`s1') & (`s2') & (`s3') & (`s4') & (`s5') & (`s6') & (`s7')  \\" _n
file write myfile "\\" _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7'  \\" _n
file write myfile "\noalign{\smallskip}" _n



***********************************************
*** Panel D. Amount per worker, no controls ***
***********************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (d): Amount per worker}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

qui reg amtpw districtUnempRateJan09, cluster(statefips)
local b1 : display %7.2f `=_b[districtUnempRateJan09]'
local s1 : display %7.2f `=_se[districtUnempRateJan09]'
local p1 = (2 * ttail(e(df_r), abs(_b[districtUnempRateJan09]/_se[districtUnempRateJan09]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpw d_unempRate_jan_07_09, cluster(statefips)
local b2 : display %7.2f `=_b[d_unempRate_jan_07_09]'
local s2 : display %7.2f `=_se[d_unempRate_jan_07_09]'
local p2 = (2 * ttail(e(df_r), abs(_b[d_unempRate_jan_07_09]/_se[d_unempRate_jan_07_09]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpw uiPerCap, cluster(statefips)
local b3 : display %7.2f `=_b[uiPerCap]'
local s3 : display %7.1f `=_se[uiPerCap]'
local p3 = (2 * ttail(e(df_r), abs(_b[uiPerCap]/_se[uiPerCap]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpw percent_dist_spent_1yr_100, cluster(statefips)
local b4 : display %7.2f `=_b[percent_dist_spent_1yr_100]'
local s4 : display %7.2f `=_se[percent_dist_spent_1yr_100]'
local p4 = (2 * ttail(e(df_r), abs(_b[percent_dist_spent_1yr_100]/_se[percent_dist_spent_1yr_100]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpw dist_emp_th, cluster(statefips)
local b5 : display %7.3f `=_b[dist_emp_th]'
local s5 : display %7.3f `=_se[dist_emp_th]'
local p5 = (2 * ttail(e(df_r), abs(_b[dist_emp_th]/_se[dist_emp_th]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpw percentPoverty, cluster(statefips)
local b6 : display %7.2f `=_b[percentPoverty]'
local s6 : display %7.2f `=_se[percentPoverty]'
local p6 = (2 * ttail(e(df_r), abs(_b[percentPoverty]/_se[percentPoverty]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg amtpw pcturban, cluster(statefips)
local b7 : display %7.3f `=_b[pcturban]'
local s7 : display %7.3f `=_se[pcturban]'
local p7 = (2 * ttail(e(df_r), abs(_b[pcturban]/_se[pcturban]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " No controls & `b1'`star1' & `b2'`star2' & `b3'`star3' & `b4'`star4' & `b5'`star5' & `b6'`star6' & `b7'`star7'  \\" _n
file write myfile "  & (`s1') & (`s2') & (`s3') & (`s4') & (`s5') & (`s6') & (`s7')  \\" _n
file write myfile " \\ " _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7'  \\" _n
file write myfile "\noalign{\smallskip}" _n



************************************************
*** Panel E. Amount per worker, all controls ***
************************************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile "\multicolumn{3}{l}{\textbf{\emph{Panel (e): Amount per worker}}} \\ \noalign{\smallskip}" _n

mac drop _b* _s* _star* _p* _r* _n*

local covars1 percentPoverty pcturban larea totalmiles

qui reg amtpw districtUnempRateJan09 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b1 : display %7.2f `=_b[districtUnempRateJan09]'
local s1 : display %7.2f `=_se[districtUnempRateJan09]'
local p1 = (2 * ttail(e(df_r), abs(_b[districtUnempRateJan09]/_se[districtUnempRateJan09]))) 
local r1 : display %7.3f `=e(r2)'
local n1 : display %7.0g `=e(N)'
qui reg amtpw d_unempRate_jan_07_09 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b2 : display %7.3f `=_b[d_unempRate_jan_07_09]'
local s2 : display %7.2f `=_se[d_unempRate_jan_07_09]'
local p2 = (2 * ttail(e(df_r), abs(_b[d_unempRate_jan_07_09]/_se[d_unempRate_jan_07_09]))) 
local r2 : display %7.3f `=e(r2)'
local n2 : display %7.0g `=e(N)'
qui reg amtpw uiPerCap v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b3 : display %7.1f `=_b[uiPerCap]'
local s3 : display %7.1f `=_se[uiPerCap]'
local p3 = (2 * ttail(e(df_r), abs(_b[uiPerCap]/_se[uiPerCap]))) 
local r3 : display %7.3f `=e(r2)'
local n3 : display %7.0g `=e(N)'
qui reg amtpw percent_dist_spent_1yr_100 v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b4 : display %7.2f `=_b[percent_dist_spent_1yr_100]'
local s4 : display %7.2f `=_se[percent_dist_spent_1yr_100]'
local p4 = (2 * ttail(e(df_r), abs(_b[percent_dist_spent_1yr_100]/_se[percent_dist_spent_1yr_100]))) 
local r4 : display %7.3f `=e(r2)'
local n4 : display %7.0g `=e(N)'
qui reg amtpw dist_emp_th v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b5 : display %7.3f `=_b[dist_emp_th]'
local s5 : display %7.3f `=_se[dist_emp_th]'
local p5 = (2 * ttail(e(df_r), abs(_b[dist_emp_th]/_se[dist_emp_th]))) 
local r5 : display %7.3f `=e(r2)'
local n5 : display %7.0g `=e(N)'
qui reg amtpw percentPoverty v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b6 : display %7.2f `=_b[percentPoverty]'
local s6 : display %7.2f `=_se[percentPoverty]'
local p6 = (2 * ttail(e(df_r), abs(_b[percentPoverty]/_se[percentPoverty]))) 
local r6 : display %7.3f `=e(r2)'
local n6 : display %7.0g `=e(N)'
qui reg amtpw pcturban v5dum1-v5dum4 v5dum6-v5dum10 `covars1' , cluster(statefips)
local b7 : display %7.3f `=_b[pcturban]'
local s7 : display %7.3f `=_se[pcturban]'
local p7 = (2 * ttail(e(df_r), abs(_b[pcturban]/_se[pcturban]))) 
local r7 : display %7.3f `=e(r2)'
local n7 : display %7.0g `=e(N)'

forvalues i = 1/7 {
	local star`i' 
	if `p`i''<0.01 {
		local star`i' "***"
	}
	else if `p`i''<0.05 {
		local star`i' "**"
	}
	else if `p`i''<0.1 {
		local star`i' "*"
	}
}

file write myfile " All controls  & `b1'`star1' & `b2'`star2' & `b3'`star3' & `b4'`star4' & `b5'`star5' & `b6'`star6' & `b7'`star7'  \\" _n
file write myfile " 			  & (`s1') & (`s2') & (`s3') & (`s4') & (`s5') & (`s6') & (`s7')  \\" _n
file write myfile "\\" _n
file write myfile " \(R^{2}\)		& `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7'  \\" _n
file write myfile "\noalign{\smallskip}" _n



********************************
*** end table and close file ***
********************************

file write myfile "\midrule \noalign{\smallskip}" _n
file write myfile " Observations 	& `n1' & `n2' & `n3' & `n4' & `n5' & `n6' & `n7'  \\" _n
file write myfile "\noalign{\smallskip}" _n

file write myfile "\bottomrule \end{tabular}" _n

cap file close myfile



*********************************************
*** delete extra spaces after parentheses ***
*********************************************

filefilter output/tables/tmp.tex output/tables/tmp1.tex, from("( ") to("(") replace
filefilter output/tables/tmp1.tex output/tables/tmp2.tex, from("( ") to("(") replace
filefilter output/tables/tmp2.tex output/tables/Table2.tex, from("( ") to("(") replace

erase output/tables/tmp.tex
erase output/tables/tmp1.tex
erase output/tables/tmp2.tex
