

*********************************
*** open file to write output ***
*********************************

cap file close myfile
file open myfile using output/tables/Table1.tex, write replace

* table header and column labels
file write myfile "\begin{tabular}{l c c c c } \toprule" _n
file write myfile "& \multicolumn{2}{c}{With Capitals} & \multicolumn{2}{c}{Without Capitals} \\ " _n
file write myfile "\multicolumn{1}{c}{Variable} & Mean & Std. Dev. & Mean & Std. Dev. \\ " _n
file write myfile "\midrule \noalign{\smallskip}" _n

************************
*** State-level vars ***
************************

file write myfile "\multicolumn{1}{l}{\textbf{\emph{State level}}} \\ \noalign{\smallskip}" _n

* use Stata state-level data set
use data/state_level_data,clear

* change units on some variables
gen fundsawarded_mil = fundsawarded / 1000000
gen _statePopJuly09 = statePopJuly09/1000000
gen _recovPrime_popTotal = recovPrime_popTotal_wcap / 1000000
gen _recovPrime_popTotal_nocap = recovPrime_popTotal_nocap / 1000000
rename amtpc_Prime_popTotal_wcap amtpc_Prime_popTotal

* label some variables
label var _recovPrime_popTotal "CGL amount (millions)"
label var _recovPrime_popTotal_nocap "CGL amount (millions)"
label var amtpc_Prime_popTotal  "CGL amount per capita"
label var fundsawarded_mil "Agency-reported amount (millions)"
label var fundsawarded_pc "Agency-reported amount per capita"
label var medpercap2005 "Medicaid per capita"
label var interstate2005percap "Interstate miles per capita"
label var _statePopJuly09 "State population (millions)"
label var change_unemp_jan_07_09 "\$\Delta\$ Unemployment Rate Jan07-Jan09"
label var state_emp_per_res "Employment per resident (\%)"
label var percent_poverty "Poverty Rate (\%)"
label var DemVoteShare "Avg Senate Dem Vote Share (\%)"

* list of variables to display
local myvarlist_state _recovPrime_popTotal amtpc_Prime_popTotal fundsawarded_mil fundsawarded_pc change_unemp_jan_07_09 state_emp_per_res percent_poverty medpercap2005 interstate2005percap _statePopJuly09 DemVoteShare

* for each variable, get the label, mean, and standard deviation (with and without capitals)
* and print output to the file
foreach v of local myvarlist_state {

	* make sure macros are empty to begin with (probably not necessary)
	local mylabel
	local mymean
	local mysd
	local mymeannocap
	local mysdnocap

	* get variable label
	local mylabel : var label `v'

	* -summarize- to get mean and s.d.
	su `v'
	local mymean : display %7.3g `r(mean)'
	local mysd : display %7.3g `r(sd)'
	
	* if the "no capitals" version of the variable exists, then -summarize- that, too
	cap su `v'_nocap
	if _rc>0 {
		local mymeannocap ""
		local mysdnocap ""
	}
	else {
		local mymeannocap : display %7.3g `r(mean)'
		local mysdnocap : display %7.3g `r(sd)'
	}
	
	* write output to the table
	file write myfile "`mylabel' & `mymean' & `mysd' & `mymeannocap' & `mysdnocap' \\" _n
}




***************************
*** District-level vars ***
***************************

file write myfile "\\" _n
file write myfile "\multicolumn{1}{l}{\textbf{\emph{District level}}} \\ \noalign{\smallskip}" _n

* preserve the state-level data for use below
preserve

* now use district-level data
use data/district_level_data,clear

* change units on some variables
gen emp1000 = dist_emp/1000
gen _recovPrime_popTotal = recovPrime_popTotal / 1000000
gen percent_dist_spent_1yr_100 = percent_dist_spent_1yr * 100

* label some variables
label var percent_dist_spent_1yr_100 "\% spent in 1 year"
label var _recovPrime_popTotal "CGL amount (millions)"
label var amtpc_Prime_popTotal "CGL amount per capita"
label var percentPoverty "Poverty Rate (\%)"
label var pcturban "Percent urban"
label var larea "Land Area (square miles)"
label var totalmiles "Total highway miles"
label var emp1000 "Employment (1000s of workers)"
label var demVoteSh_house "House Democratic vote share"
label var nterms_house "Tenure (number of 2-year terms)"
label var dw1 "DW-Nominate score"
label var amtpw "Stimulus amount per worker" 


* list of variables to display
local myvarlist _recovPrime_popTotal amtpc_Prime_popTotal amtpw percentPoverty pcturban larea totalmiles emp1000 percent_dist_spent_1yr_100 demVoteSh_house nterms_house dw1


* for each variable, get the label, mean, and standard deviation (with and without capitals)
* and print output to the file
foreach v of local myvarlist {

	* make sure macros are empty to begin with (probably not necessary)
	local mylabel
	local mymean
	local mysd
	local mymeannocap
	local mysdnocap

	* get variable label
	local mylabel : var label `v'

	* -summarize- to get mean and s.d.
	su `v'
	local mymean : display %7.3g `r(mean)'
	local mysd : display %7.3g `r(sd)'
	su `v' if iscap==0
	local mymeannocap : display %7.3g `r(mean)'
	local mysdnocap : display %7.3g `r(sd)'

	* write output to the table
	file write myfile "`mylabel' & `mymean' & `mysd' & `mymeannocap' & `mysdnocap' \\" _n

}



*****************************
*** Total stimulus amount ***
*****************************

restore

file write myfile "\\" _n

** first aggregate CGL funds from state-level data set
replace _recovPrime_popTotal = _recovPrime_popTotal/1000
replace _recovPrime_popTotal_nocap = _recovPrime_popTotal_nocap / 1000
su _recovPrime_popTotal
local mysum : display %7.2g `r(sum)'
su _recovPrime_popTotal_nocap
local mysumnocap : display %7.2g `r(sum)'
local mysum = ltrim("`mysum'")
local mysumnocap = ltrim("`mysumnocap'")
file write myfile "\textbf{\emph{Total CGL amount}} & \multicolumn{2}{c}{\\$`mysum' billion} & \multicolumn{2}{c}{\\$`mysumnocap' billion} \\" _n

file write myfile "\noalign{\smallskip}" _n

** now aggregate state-level agency-reported funds
use data/state_level_data,clear
gen _fundsawarded = fundsawarded / 1000000000
su _fundsawarded
local mysum : display %7.2g `r(sum)'
local mysum = ltrim("`mysum'")
file write myfile "\textbf{\emph{Total agency-reported amount}} & \multicolumn{2}{c}{\\$`mysum' billion}  \\" _n

file write myfile "\bottomrule \end{tabular}" _n

cap file close myfile


