

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

* get list of control variables
local covars percentPoverty pcturban larea totalmiles

* Panel a. Not controlling for democratic vote share
preserve
plreglpci amtpc  `covars' dist_emp,  nlf(dw1) gen(mygrid ehat) bw(.29) 
sort mygrid
scatter ehat_min ehat ehat_max mygrid,  subtitle("(a) No vote share controls", pos(11)) xtitle("DW-NOMINATE (left-wing on right)") ms(i i i) c(l l l) lp(- l -) lc(black black black) legend(off) xline(0, lpattern(.)) graphregion(fcolor(white) lcolor(white)) xscale(reverse) ylabel(,nogrid)
graph save output/figures/g2.gph, replace
restore

* Panel b. Controlling for democratic vote share
preserve
plreglpci amtpc demVoteSh_house `covars' dist_emp,  nlf(dw1) gen(mygrid ehat) bw(.29) 
sort mygrid
scatter ehat_min ehat ehat_max mygrid, subtitle("(b) Control for vote share", pos(11)) xtitle("DW-NOMINATE (left-wing on right)") ms(i i i) c(l l l) lp(- l -) lc(black black black) legend(off) xline(0, lpattern(.)) graphregion(fcolor(white) lcolor(white)) xscale(reverse) ylabel(,nogrid)
graph save output/figures/g1.gph, replace
restore

* combine and export
graph combine output/figures/g2.gph output/figures/g1.gph, ///
	ycommon xcommon l1title("stimulus amount per resident ($)") graphregion(fcolor(white) lcolor(white))
graph export output/figures/FigureA8.$figureFormat, replace

* clean up
erase output/figures/g1.gph 
erase output/figures/g2.gph


