
use data/district_level_data, clear

* drop state capitals
drop if iscap==1

* panel a
tw (lpolyci amtpc districtUnempRateJan09) (scatter amtpc districtUnempRateJan09, mc(gs5)), ///
legend(off) xtitle("District Unemployment Rate, January 2009") subtitle("(a) Unemployment Rate", pos(11)) ///
saving(output/figures/g1.gph,replace) graphregion(fcolor(white) lcolor(white)) ylabel(,nogrid) 

* panel b
tw (lpolyci amtpc d_unempRate_jan_07_09) (scatter amtpc d_unempRate_jan_07_09, mc(gs5)), ///
legend(off) xtitle("Change in Unemployment, Jan07 to Jan09") subtitle("(b) Excess Capacity", pos(11)) ///
saving(output/figures/g2.gph,replace) graphregion(fcolor(white) lcolor(white)) ylabel(,nogrid) 

* combine and export
graph combine output/figures/g1.gph output/figures/g2.gph, graphregion(fcolor(white) lcolor(white)) l1title("Amount per resident ($)")
graph export output/figures/FigureA4.$figureFormat, replace

* clean up
erase output/figures/g1.gph
erase output/figures/g2.gph

clear
