

************************************
*** Fig A1: money spent by state ***
************************************

* code below creates stata file from shp file for US States
*cap erase data/stcoord.dta
*cap erase data/stdb.dta
*shp2dta using s_28au12.shp, database(data/stdb) coordinates(data/stcoord) genid(stid)

* stdb.dta and stcoord.dta are Stata datasets containing spatial information from a shapefile of U.S. states
use data/spatial/stdb,clear
drop if inlist(FIPS,"72","11","60","66","78")
rename STATE stateabbrev
keep stid stateabbrev

* merge in ARRA data
merge 1:1 stateabbrev using data/state_level_data, keepusing(fundspaidout statePopJuly09) assert(2 3) keep(3) nogen
gen fundspaidout_pc = fundspaidout / statePopJuly09

* make the map
format %6.0f fundspaidout_pc
spmap fundspaidout_pc if ~inlist(stateabbrev,"AK","HI") using data/spatial/stcoord, id(stid) fcolor(Blues) cln(9) 
graph export output/figures/FigureA1.$figureFormat, replace


****************************************************************
*** Fig A2a: money spent by district, with state capitals    ***
*** Fig A2b: money spent by district, without state capitals ***
****************************************************************

* distdb.dta and distcoord.dta are Stata datasets containing spatial information from a shapefile of U.S. congressional districts
use data/spatial/distdb,clear
drop if STATEFP10=="72" | STATEFP10=="11"
rename GEOID10 district
keep distid district 

* merge in ARRA data
merge m:1 district using data/district_level_data, keepusing(amtpc_Prime_popTotal stateabbrev iscap) assert(3) nogen

gen nocap = !iscap
gen myamtpc = amtpc_Prime_popTotal if iscap==0

* make the maps
format %6.0f amtpc_Prime_popTotal
spmap amtpc_Prime_popTotal if ~inlist(stateabbrev,"AK","HI") using data/spatial/distcoord, id(distid) fcolor(Blues) cln(9) 
graph export output/figures/FigureA2a.$figureFormat, replace

format %6.0f myamtpc 
spmap myamtpc if ~inlist(stateabbrev,"AK","HI") using data/spatial/distcoord, id(distid) fcolor(Blues) cln(9) ndfcolor(gray) ndlabel("State Capitals")
graph export output/figures/FigureA2b.$figureFormat, replace


