


*****************************************************************************
*** a. Amount per resident versus democratic vote share: by percent urban ***
*****************************************************************************

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

* plot amount per capita vs democratic vote share, by percent urban
twoway (lpoly amtpc demVoteSh_house, lc(gs3) )  ///
	   (scatter amtpc demVoteSh_house if pcturban<=90, mc(gs13) ) ///
	   (scatter amtpc demVoteSh_house if pcturban>90 & pcturban<=99, mc(gs7) ) ///
	   (scatter amtpc demVoteSh_house if pcturban>99 & pcturban<., mc(gs0) )  ///
	   , legend(order(2 "0-90%" 3 "90-99%" 4 "99-100% urban") r(1)) ///
	   graphregion(fcolor(white) lcolor(white)) subtitle("(a) by percent urban", pos(11)) xtitle("") ytitle("") ylabel(0(2000)4000,nogrid)
graph save output/figures/amountVsVoteShare_byPctUrban.gph, replace



************************************************************************************
*** b. Amount per resident versus democratic vote share: by Congressional tenure ***
************************************************************************************

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

* get variable for tenure quartiles
su nterms_house, detail
local nterms_25 = r(p25)
local nterms_50 = r(p50)
local nterms_75 = r(p75)
gen nterms_quartile = .
replace nterms_quartile = 1 if nterms_house < `nterms_25' 
replace nterms_quartile = 2 if nterms_house < `nterms_50' & nterms_house >= `nterms_25'
replace nterms_quartile = 3 if nterms_house < `nterms_75' & nterms_house >= `nterms_50'
replace nterms_quartile = 4 if nterms_house >= `nterms_75' 

* plot amount per capita vs democratic vote share, by number of terms
twoway (lpoly amtpc demVoteSh_house, lc(gs3) )  ///
	   (scatter amtpc demVoteSh_house if nterms_quartile==1, mc(gs13) ) ///
	   (scatter amtpc demVoteSh_house if nterms_quartile==2, mc(gs10) ) ///
	   (scatter amtpc demVoteSh_house if nterms_quartile==3, mc(gs5) )  ///
	   (scatter amtpc demVoteSh_house if nterms_quartile==4, mc(gs0) )  ///
	   , legend(order(2 "newest members" 5 "longest tenure")) ///
	   graphregion(fcolor(white) lcolor(white)) subtitle("(b) by tenure", pos(11)) xtitle("") ytitle("") ylabel(0(2000)4000,nogrid)
graph save output/figures/amountVsVoteShare_byTenure.gph, replace




************************************************************************
*** c. Amount per capita versus democratic vote share: by leadership ***
************************************************************************

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

* plot amount per capita vs democratic vote share, by number of terms
twoway (scatter amtpc demVoteSh_house if isLeaderChairRm==0, mc(gray) ) ///
	   (lpoly amtpc demVoteSh_house, lc(gs3) )  ///
	   (scatter amtpc demVoteSh_house if isRmOrRepLeader==1, mc(red) )  ///
	   (scatter amtpc demVoteSh_house if isChairOrDemLeader==1, mc(blue) ) ///
	   , legend(order(3 "R leader" 4 "D leader")) graphregion(fcolor(white) lcolor(white)) ///
	   subtitle("(c) by party leadership", pos(11)) xtitle("") ytitle("") ylabel(0(2000)4000,nogrid)
graph save output/figures/amountVsVoteShare_byLeadership.gph, replace



***********************************************************************
*** d. Amount per capita versus democratic vote share: by ARRA vote ***
***********************************************************************

use data/district_level_data,clear

* drop state capitals
drop if iscap==1

* get arra votes, including not voting
* the following districts abstained from ARRA votes: 0648, 3626, 4506 (capital district)
gen arrayes = vote=="Yea"
gen arraVote = arrayes
replace arraVote = 2 if district=="0648" | district=="3626" | district=="4506"
* the following districts didn't have any representatives, so there was no vote
replace arraVote = . if district=="1705" | district=="3620"
gen arraVoteAgainst_inclAbstain = 0
replace arraVoteAgainst_inclAbstain = . if district=="1705" | district=="3620"
replace arraVoteAgainst_inclAbstain = 1 if dem==1 & inlist(arraVote,0,2)
replace arraVoteAgainst_inclAbstain = 1 if dem==0 & inlist(arraVote,1,2)

* plot amount per capita vs democratic vote share, indicating members that vote against their party (including abstentions)
twoway (scatter amtpc demVoteSh_house if arraVoteAgainst_inclAbstain==0, mc(gray) )              ///
	   (lpoly amtpc demVoteSh_house, lc(gs3) )  ///
	   (scatter amtpc demVoteSh_house if arraVoteAgainst_inclAbstain==1 & dem==0, mc(red) )      ///
	   (scatter amtpc demVoteSh_house if arraVoteAgainst_inclAbstain==1 & dem==1, mc(blue) )     ///
	   , legend(order(3 "Repub voting YES or abstaining" 4 "Dem voting NO or abstaining") r(2))  ///
	   graphregion(fcolor(white) lcolor(white)) ///
	   subtitle("(d) by ARRA vote", pos(11)) xtitle("") ytitle("") ylabel(0(2000)4000,nogrid)
graph save output/figures/amountVsVoteShare_byVoteARRA.gph, replace



******************************************************
*** Combine figures into one, export, and clean up ***
******************************************************

graph combine output/figures/amountVsVoteShare_byPctUrban.gph output/figures/amountVsVoteShare_byTenure.gph ///
	output/figures/amountVsVoteShare_byLeadership.gph output/figures/amountVsVoteShare_byVoteARRA.gph ///
	, graphregion(fcolor(white) lcolor(white)) l1title("Amount per resident ($)") b1title("Democratic vote share (%)")
graph export output/figures/Figure6.$figureFormat, replace



erase output/figures/amountVsVoteShare_byPctUrban.gph
erase output/figures/amountVsVoteShare_byTenure.gph
erase output/figures/amountVsVoteShare_byLeadership.gph
erase output/figures/amountVsVoteShare_byVoteARRA.gph

clear
