* use this file to replicate the figures in Boone, Dube and Kaplan (2014)
* this is Stata code
* last updated 2015.02.28

* TO RUN THIS PROGRAM:
*   -- you must enter the correct file path in section 0 to set "/BooneDubeKaplan" as your working directory
*   -- the files plreglpci.ado and lpolyci.ado must be saved somewhere Stata can see them (e.g., in the working directory or one of your personal ado-directories. see section 0 below.)


**************************
**** 0. prepare stata ****
**************************
clear all
macro drop _all
set more off 

** MUST CHANGE THE FILE PATH BELOW TO THE APPROPRIATE DIRECTORY! **
cd "C:/Users/<CHANGE_THIS_FILE_PATH>/Downloads/BooneDubeKaplan/"

** required programs
cap ssc install spmap
* copy plreglpci.ado and lpolyci.ado to the working directory
copy code/makeFigures/plreglpci.ado .
copy code/makeFigures/lpolyci.ado .

** choose desired file format for figure output
*global figureFormat png
*global figureFormat pdf
global figureFormat eps


***************************************
**** 1. Replicate figures in paper ****
***************************************

* Figure 1 - Histograms
do code/makeFigures/figure_1.do

* Figure 2 - District-level outliers
do code/makeFigures/figure_2.do

* Figure 3 - District-level stimulus amount per resident and amount per worker
do code/makeFigures/figure_3.do

* Figure 4 - District-level non-parametric and semi-parametric regressions of amount per resident on vote share
do code/makeFigures/figure_4.do

* Figure 5 - District-level non-parametric and semi-parametric regressions of amount per worker on vote share
do code/makeFigures/figure_5.do

* Figure 6 - District-level stimulus amount per resident
do code/makeFigures/figure_6.do


*************************************************
**** 2. Replicate figures in online appendix ****
*************************************************

* Figures A1, A2a and A2b - Maps: State-level and district-level stimulus amount per resident
do code/makeFigures/figure_A1_A2.do

* Figure A3 - Proportion of total district amount accounted for by largest 5% of awards in that district
do code/makeFigures/figure_A3.do

* Figure A4 - District-level: Amount per resident vs. unemployment rate and excess capacity
do code/makeFigures/figure_A4.do

* Figure A5 - District-level: Shovel readiness
do code/makeFigures/figure_A5.do

* Figure A6 - State-level amount per resident vs. presidential vote share
do code/makeFigures/figure_A6.do

* Figure A7 - District-level: Amount per resident vs. congressional tenure
do code/makeFigures/figure_A7.do

* Figure A8 - Semi-parametric regression of amount per resident on DW-Nominate score (controlling for Democratic vote share)
do code/makeFigures/figure_A8.do


clear



