%Make Quarterly weather data
function mq=makequarterly(spec);
m=xlsread('WeatherData.xlsx','Sheet1','IT276:JC20637');
if spec==2; m(:,5)=m(:,7); end;
if spec>=4; m(:,4)=m(:,8); end; %Replace snowfall with one of the ReSIS indices.
m=m(:,1:7);
mz=m;
u=unique(m(:,2));
n=length(u);
for i=1:n;
    g=find(m(:,2)==u(i));
    for t=31:length(g);
        mz(g(t),3)=m(g(t),3)-mean(m(g(t-30:t-1),3));
        mz(g(t),4)=m(g(t),4)-mean(m(g(t-30:t-1),4));
        mz(g(t),5)=m(g(t),5)-mean(m(g(t-30:t-1),5));
        mz(g(t),6)=m(g(t),6)-mean(m(g(t-30:t-1),6));
        mz(g(t),7)=m(g(t),7)-mean(m(g(t-30:t-1),7));
    end;
end;  
m=mz(10959:end,:);  %Start October 1 1989
q=m(:,1)+(floor((m(:,2)-100)/300)*0.25);
u=unique(q);
n=length(u);
for i=1:n;
    g=find(q==u(i));
    mq(i,1)=mean(m(g,3));
    mq(i,2)=mean(m(g,4));
    mq(i,3)=mean(m(g,5));
    mq(i,4)=mean(m(g,6));
    mq(i,5)=mean(m(g,7));
end;

d=[kron([1989:1:2015]',ones(4,1)) kron(ones(27,1),[1;2;3;4])];
mq=[d(4:end-2,:) mq];