close all;
gmax=30;
g=[0:1:gmax]';
g=g/gmax;
theta=xlsread('midasparams.xls',1,'B2:B3');
g=exp((theta(1)*g)+(theta(2)*(g.^2))); g=g/sum(g);
figure(1);
subplot(2,1,1);
plot([0:1:gmax]',g,'Linewidth',2);
ylabel('Weight','Fontsize',14);
xlabel('j','Fontsize',14);
title('Specification 4','Fontsize',14);
g=[0:1:gmax]';
g=g/gmax;
theta=xlsread('midasparams.xls',1,'H2:H5');
g=exp((theta(1)*g)+(theta(2)*(g.^2))); g=g/sum(g);
g=[g;theta(3)*ones(gmax,1);theta(4)*ones(gmax,1)];
subplot(2,1,2);
plot([0:1:3*gmax]',g,'Linewidth',2);
ylabel('Weight','Fontsize',14);
ylim([-0.02 0.1]);
xlabel('j','Fontsize',14);
title('Specification 7','Fontsize',14);
%---Regular version-----%
m1=xlsread('bls.xls','sa','EW4:EW308');
m3=xlsread('bls.xls','swa4','EW4:EW308');
totaleffect=m1-m3;
totaleffect=totaleffect(2:end)-totaleffect(1:end-1);
m1c=xlsread('bls.xls','sa','EZ4:EZ308');
m3c=xlsread('bls.xls','swa4','FB4:FB308');
totaleffectc=m1c-m3c;
totaleffectc=totaleffectc(2:end)-totaleffectc(1:end-1);
x=[];
for j=1990:1:2015; x=[x;datenum(j,[1:12]',15)]; end;
x=x(2:305);
figure(2);
clear axes;
axes=axes('Fontsize',12);
subplot(2,1,1);
set(gca,'linewidth',2);
scatter(x,m1(2:end)-m1(1:end-1),10,'fill')
hold on;
scatter(x,m3(2:end)-m3(1:end-1),10,'r','fill')
datetick('x','mmmyy');
set(gca,'box','on','linewidth',2);
axis([datenum(1989,12,15) datenum(2015,7,15) -900 900]);
legend({'SA','SWA'},'Fontsize',10)
ylabel('Employment (000s)','Fontsize',12);
title('SA and SWA Month-over-Month Payrolls Changes','Fontsize',12)
subplot(2,1,2);
bar(x,totaleffect);
datetick('x','mmmyy');
axis([datenum(1989,12,15) datenum(2015,7,15) -200 200]);
ylabel('Employment (000s)','Fontsize',12);
set(gca,'linewidth',2);
title('SA less SWA Month-over-Month Payrolls Changes','Fontsize',12)
a=corrcoef([totaleffect(2:end) totaleffect(1:end-1)]);
disp('Specification 4: Autocorrelation in Monthly Changes');
disp(a(1,2));
figure(3);
acf=autocorr(totaleffect,24);
clear axes;
axes=axes('Fontsize',12);
set(gca,'linewidth',2);
bar([1:1:24]',acf(2:25));
axis([0.3 24.5 -0.6 0.6]);
g=1.96/sqrt(length(totaleffect));
line([0.3 24.5],[-g -g],'LineStyle','--','Color','k')
line([0.3 24.5],[g g],'LineStyle','--','Color','k')
xlabel('Lag (months)','Fontsize',12);
figure(4);
clear axes;
axes=axes('Fontsize',12);
bar(x,totaleffectc);
datetick('x','mmmyy');
axis([datenum(1989,12,15) datenum(2015,7,15) -60 60]);
ylabel('Employment (000s)','Fontsize',12);
set(gca,'linewidth',2);
%---Alt Measures Comparisons-----%
clear;
m1=xlsread('bls.xls','swa4','EW4:EW308');
m2=xlsread('bls.xls','swa5','EW4:EW308');
m3=xlsread('bls.xls','swa6','EW4:EW308');
m4=xlsread('bls.xls','swa7','EW4:EW308');
m5=xlsread('bls.xls','swa8','EW4:EW308');
totaleffect1=m2-m1; totaleffect2=m3-m1; totaleffect3=m4-m1; totaleffect4=m5-m1;
totaleffect1=totaleffect1(2:end)-totaleffect1(1:end-1);
totaleffect2=totaleffect2(2:end)-totaleffect2(1:end-1);
totaleffect3=totaleffect3(2:end)-totaleffect3(1:end-1);
totaleffect4=totaleffect4(2:end)-totaleffect4(1:end-1);
x=[];
for j=1990:1:2015; x=[x;datenum(j,[1:12]',15)]; end;
x=x(2:305);
figure(5);
clear axes;
axes=axes('Fontsize',12);
subplot(2,2,1);
bar(x,totaleffect1);
set(gca,'linewidth',2);
title('Specification 5 v. 4');
ylabel('Employment (000s)','Fontsize',12);
datetick('x','mmmyy');
axis([datenum(1989,12,15) datenum(2015,7,15) -220 220]);
subplot(2,2,2);
bar(x,totaleffect2);
set(gca,'linewidth',2);
title('Specification 6 v. 4');
datetick('x','mmmyy');
axis([datenum(1989,12,15) datenum(2015,7,15) -220 220]);
subplot(2,2,3);
bar(x,totaleffect3);
set(gca,'linewidth',2);
title('Specification 7 v. 4');
ylabel('Employment (000s)','Fontsize',12);
datetick('x','mmmyy');
axis([datenum(1989,12,15) datenum(2015,7,15) -220 220]);
subplot(2,2,4);
bar(x,totaleffect4);
set(gca,'linewidth',2);
title('Specification 8 v. 4');
datetick('x','mmmyy');
axis([datenum(1989,12,15) datenum(2015,7,15) -220 220]);
%---Spec 7------%
clear;
m1=xlsread('bls.xls','sa','EW4:EW308');
m3=xlsread('bls.xls','swa7','EW4:EW308');
totaleffect=m1-m3;
totaleffect=totaleffect(2:end)-totaleffect(1:end-1);
x=[];
for j=1990:1:2015; x=[x;datenum(j,[1:12]',15)]; end;
x=x(2:305);
figure(6);
clear axes;
axes=axes('Fontsize',12);
bar(x,totaleffect);
datetick('x','mmmyy');
axis([datenum(1989,12,15) datenum(2015,7,15) -220 220]);
set(gca,'linewidth',2);
ylabel('Employment (000s)','Fontsize',12);
a=corrcoef([totaleffect(2:end) totaleffect(1:end-1)]);
disp('Specification 7: Autocorrelation in Monthly Changes');
disp(a(1,2));
