function Flag = mycompatible(V1,V2)
% mycompatible  [Not a public function] True if two varobj objects can occur together on the LHS and RHS in an assignment.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2015 IRIS Solutions Team.

%--------------------------------------------------------------------------

try
    Flag = isequal(class(V1),class(V2)) ...
        && isequal(V1.YNames,V2.YNames) ...
        && isequal(V1.ENames,V2.ENames) ...
        && isequal(V1.XNames,V2.XNames) ...
        && rngcmp(V1.Range,V2.Range) ...
        && size(V1.A,1) == size(V2.A,1) ...
        && size(V1.A,2) == size(V2.A,2) ...
        && size(V1.K,1) == size(V2.K,1) ...
        && size(V1.K,2) == size(V2.K,2) ...
        && size(V1.J,1) == size(V2.J,1) ...
        && size(V1.J,2) == size(V2.J,2);        
catch %#ok<CTCH>
    Flag = false;
end

end
