classdef graphobj < report.genericobj
    
    methods
        
        function This = graphobj(varargin)
            This = This@report.genericobj(varargin{:});
            This.childof = {'figure'};
            This.default = [This.default, { ...
                'axesoptions',{},@(x) iscell(x) && iscellstr(x(1:2:end)),true, ...
                'rhsaxesoptions',{},@(x) iscell(x) && iscellstr(x(1:2:end)),true, ...
                'datetick',@auto,@(x) isequal(x,@auto) || isnumeric(x),true, ...
                'grid',@auto,@(x) isequal(x,@auto) || islogicalscalar(x),true, ...
                'highlight',[],@(x) isnumeric(x) ...
                || (iscell(x) && all(cellfun(@isnumeric,x))),true, ... Obsolete, use highlight object.
                'legend',false,@(x) islogical(x) || isnumeric(x),true, ...
                'legendlocation','NorthEast',@ischar,true, ...
                'legendoptions',{},@(x) iscell(x) && iscellstr(x(1:2:end)),true, ...
                'preprocess','',@(x) isempty(x) || ischar(x),true, ...
                'postprocess','',@(x) isempty(x) || ischar(x),true, ...
                'range',Inf,@isnumeric,true, ...
                'style',[],@(x) isempty(x) || isstruct(x),true, ...
                'tight',@auto,@(x) isequal(x,@auto) || islogicalscalar(x),true, ...
                'titleoptions',{},@(x) iscell(x) && iscellstr(x(1:2:end)),true, ...
                'xlabel','',@ischar,true, ...
                'ylabel','',@ischar,true, ...
                'zlabel','',@ischar,true, ...
                'zeroline',false, ...
                @(x) islogical(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
                true, ...
                ...
                ... Date format options
                ...---------------------
                'dateformat',@config,@config,true, ...
                'freqletters',@config,@config,true, ...
                'months',@config,@config,true, ...
                'standinmonth',@config,@config,true, ...
                }];
        end        
        
        function [This,varargin] = specargin(This,varargin)
        end
        
        function This = setoptions(This,varargin)
            This = setoptions@report.genericobj(This,varargin{:});
            % Remove equal signs from name-value pairs of options passed into Matlab
            % functions.
            list = {'axes','rhsaxes','legend','title'};
            for i = 1 : length(list)
                name = [list{i},'options'];
                if ~isempty(This.options.(name))
                    This.options.(name)(1:2:end) ...
                        = strrep(This.options.(name)(1:2:end),'=','');
                end
            end
        end        
        
        function Ax = subplot(This,R,C,I,varargin) %#ok<INUSL>
            Ax = subplot(R,C,I,varargin{:});
        end
        
        varargout = plot(varargin)
        
    end
    
end
