function Def = latex()
% latex  [Not a public function] Default options for latex package functions.
%
% Backend IRIS function.
% No help provided.

% The IRIS Toolbox.
% -Copyright (c) 2007-2015 IRIS Solutions Team.

%--------------------------------------------------------------------------

Def = struct();

Def.epstopdf = {...
    'display',false,@islogical,...
    };

Def.compilepdf = { ...
    'cd',false,@islogicalscalar, ...
    'display',true,@islogicalscalar, ...
    'echo',false,@islogicalscalar, ...
    'maxrerun',5,@isnumericscalar, ...
    'minrerun',1,@isnumericscalar, ...
    };

Def.publish = { ...
    'author','',@ischar, ...
    'cleanup',true,@islogicalscalar, ...
    'closeall',true,@islogicalscalar, ...
    'date','\today',@ischar, ...
    'deletetempfiles,cleanup',[],@(x) isempty(x) || islogicalscalar(x), ...
    'display',true,@islogicalscalar, ...
    'evalcode',true,@islogicalscalar, ...
    'event','',@ischar, ...
    'figureframe',false,@islogicalscalar, ...
    'figurescale',ishg2(0.75,1),@(x) isnumericscalar(x) && x > 0, ...
    'figuretrim',[50,210,50,180],@(x) isnumeric(x) && numel(x) == 4, ...
    'figurewidth','4in',@ischar, ...
    'irisversion',true,@islogicalscalar, ...
    'linespread','auto',@(x) (ischar(x) && strcmpi(x,'auto')) ...
    || isnumericscalar(x) && x > 0, ...
    'matlabversion',true,@islogicalscalar, ...
    'numbered',true,@islogicalscalar, ...
    'papersize','letterpaper', ...
    @(x) isequal(x,'a4paper') || isequal(x,'letterpaper'), ...
    'preamble','',@ischar, ...
    'package',{},@(x) iscellstr(x) || ischar(x) || isempty(x), ...
    'template','paper',@(x) ischar(x) && any(strcmpi(x,{'paper','present'})), ...
    'textscale',0.70,@isnumericscalar, ...
    'toc',true,@islogicalscalar, ...
    'usenewfigure',false,@islogicalscalar, ...
    };

end
