function Def = dates()
% dates  [Not a public function] Default options for IRIS date functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2015 IRIS Solutions Team.

%--------------------------------------------------------------------------

Def = struct();

dates = { ...
    'dateformat',@config,@config, ...
    'freqletters,freqletter',@config,@config, ...
    'months,month',@config,@config, ...
    'standinmonth',@config,@config, ...
    'wwday',@config,@config, ...
    };

Def.convert = { ...
   dates{:}, ...
};

Def.dat2str = { ...
    dates{:}, ...
}; %#ok<CCAT1>

Def.datxtick = { ...
    dates{:}, ...
    'dateposition','c',@(x) ischar(x) && ~isempty(x) && any(x(1) == 'sec'), ...
    'datetick,dateticks','auto',@(x) isequal(x,'auto') || isnumeric(x) ...
    || isanystri(x,{'yearstart','yearend','yearly'}) || isfunc(x), ...
}; %#ok<CCAT>

Def.str2dat = { ...
    dates{:}, ...
   'freq',[],@(x) isempty(x) ...
      || (isnumericscalar(x) && any(x == [0,1,2,4,6,12,52,365])) ...
      || isequal(x,'daily'), ...
}; %#ok<CCAT>

end
