function Def = FAVAR()
% FAVAR   [Not a public function] Default options for FAVAR class functions.

%--------------------------------------------------------------------------

Def = struct();

Def.estimate = { ...
    'cross',true, ...
    @(x) islogicalscalar(x) || (isnumericscalar(x) && x >=0 && x <= 1), ...
    'method','auto',@(x) isequal(x,'auto') || isequal(x,1) || isequal(x,2), ...
    'order',1,@(x) isnumericscalar(x), ...
    'output','auto',@(x) isequal(x,'auto') ...
    || isanystri(x,{'dbase','tseries','array'}), ...
    'rank',Inf,@(x) isnumericscalar(x), ...
    'tolerance','auto',@(x) isequal(x,'auto') || isnumericscalar(x), ...
    'ynames,yname',@(n) ['y',sprintf('%g',n)],@(x) iscellstr(x) || isfunc(x), ...
    };

Def.filter = { ...
    'cross',true, ...
    @(x) islogicalscalar(x) || (isnumericscalar(x) && x >=0 && x <= 1), ...
    'invfunc','auto',@(x) isequal(x,'auto') || isfunc(x), ...
    'meanonly',false,@islogicalscalar, ...
    'output','auto',@(x) isequal(x,'auto') ...
    || isanystri(x,{'dbase','tseries','array'}), ...
    'persist',false,@islogicalscalar, ...
    'tolerance',0,@(x) isnumericscalar(x), ...
    };

Def.forecast = { ...
    'cross',true, ...
    @(x) islogicalscalar(x) || (isnumericscalar(x) && x >=0 && x <= 1), ...
    'invfunc','auto',@(x) isequal(x,'auto') || isfunc(x), ...
    'meanonly',false,@islogicalscalar, ...
    'output','auto',@(x) isequal(x,'auto') ...
    || isanystri(x,{'dbase','tseries','array'}), ...
    'persist',false,@islogicalscalar, ...
    'tolerance',0,@(x) isnumericscalar(x), ...
    };

end
